/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.support.ApiConstants;
import io.nats.client.support.JsonUtils;

public class Error {
    public static final int NOT_SET = -1;
    private final String json;
    private final Integer code;
    private final String desc;

    static Error optionalInstance(String json) {
        String errorJson = JsonUtils.getJsonObject("error", json, null);
        return errorJson == null ? null : new Error(errorJson);
    }

    Error(String json) {
        this.json = json;
        this.code = JsonUtils.readInt(json, ApiConstants.CODE_RE, -1);
        this.desc = JsonUtils.readString(json, ApiConstants.DESCRIPTION_RE, null);
    }

    public long getCode() {
        return this.code.intValue();
    }

    public String getDescription() {
        return this.desc;
    }

    public String toString() {
        if (this.desc == null) {
            return this.code == -1 ? "Unknown JetStream Error: " + this.json : "Unknown JetStream Error (" + this.code + ")";
        }
        return this.desc + " (" + this.code + ")";
    }
}

