/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.JetStreamApiException;
import io.nats.client.Message;
import io.nats.client.api.ApiResponse;
import io.nats.client.support.ApiConstants;
import io.nats.client.support.JsonUtils;
import java.io.IOException;

public class PublishAck
extends ApiResponse<PublishAck> {
    private final String stream;
    private final long seq;
    private final boolean duplicate;

    public PublishAck(Message msg) throws IOException, JetStreamApiException {
        super(msg);
        this.throwOnHasError();
        this.stream = JsonUtils.readString(this.json, ApiConstants.STREAM_RE, null);
        if (this.stream == null) {
            throw new IOException("Invalid JetStream ack.");
        }
        this.seq = JsonUtils.readLong(this.json, ApiConstants.SEQ_RE, 0L);
        if (this.seq == 0L) {
            throw new IOException("Invalid JetStream ack.");
        }
        this.duplicate = JsonUtils.readBoolean(this.json, ApiConstants.DUPLICATE_RE);
    }

    public long getSeqno() {
        return this.seq;
    }

    public String getStream() {
        return this.stream;
    }

    public boolean isDuplicate() {
        return this.duplicate;
    }

    public String toString() {
        return "PublishAck{stream='" + this.stream + '\'' + ", seq=" + this.seq + ", duplicate=" + this.duplicate + "}";
    }
}

