/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.support.ApiConstants;
import io.nats.client.support.JsonUtils;
import java.time.ZonedDateTime;

public class StreamState {
    private final long msgs;
    private final long bytes;
    private final long firstSeq;
    private final long lastSeq;
    private final long consumerCount;
    private final ZonedDateTime firstTime;
    private final ZonedDateTime lastTime;

    StreamState(String json) {
        this.msgs = JsonUtils.readLong(json, ApiConstants.MESSAGES_RE, 0L);
        this.bytes = JsonUtils.readLong(json, ApiConstants.BYTES_RE, 0L);
        this.firstSeq = JsonUtils.readLong(json, ApiConstants.FIRST_SEQ_RE, 0L);
        this.lastSeq = JsonUtils.readLong(json, ApiConstants.LAST_SEQ_RE, 0L);
        this.consumerCount = JsonUtils.readLong(json, ApiConstants.CONSUMER_COUNT_RE, 0L);
        this.firstTime = JsonUtils.readDate(json, ApiConstants.FIRST_TS_RE);
        this.lastTime = JsonUtils.readDate(json, ApiConstants.LAST_TS_RE);
    }

    public long getMsgCount() {
        return this.msgs;
    }

    public long getByteCount() {
        return this.bytes;
    }

    public long getFirstSequence() {
        return this.firstSeq;
    }

    public ZonedDateTime getFirstTime() {
        return this.firstTime;
    }

    public long getLastSequence() {
        return this.lastSeq;
    }

    public ZonedDateTime getLastTime() {
        return this.lastTime;
    }

    public long getConsumerCount() {
        return this.consumerCount;
    }

    public String toString() {
        return "StreamState{msgs=" + this.msgs + ", bytes=" + this.bytes + ", firstSeq=" + this.firstSeq + ", lastSeq=" + this.lastSeq + ", consumerCount=" + this.consumerCount + ", firstTime=" + this.firstTime + ", lastTime=" + this.lastTime + '}';
    }
}

