/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.JetStreamApiException;
import io.nats.client.JetStreamOptions;
import io.nats.client.Message;
import io.nats.client.api.ConsumerConfiguration;
import io.nats.client.api.ConsumerCreateRequest;
import io.nats.client.api.ConsumerInfo;
import io.nats.client.impl.Headers;
import io.nats.client.impl.NatsConnection;
import io.nats.client.support.NatsJetStreamConstants;
import java.io.IOException;
import java.time.Duration;

class NatsJetStreamImplBase
implements NatsJetStreamConstants {
    protected final NatsConnection conn;
    protected final JetStreamOptions jso;

    NatsJetStreamImplBase(NatsConnection connection, JetStreamOptions jsOptions) throws IOException {
        this.conn = connection;
        this.jso = JetStreamOptions.builder(jsOptions).build();
    }

    protected ConsumerInfo getConsumerInfo(String streamName, String consumer) throws IOException, JetStreamApiException {
        String subj = String.format("CONSUMER.INFO.%s.%s", streamName, consumer);
        Message resp = this.makeRequestResponseRequired(subj, null, this.jso.getRequestTimeout());
        return (ConsumerInfo)new ConsumerInfo(resp).throwOnHasError();
    }

    protected ConsumerInfo addOrUpdateConsumerInternal(String streamName, ConsumerConfiguration config) throws IOException, JetStreamApiException {
        String durable = config.getDurable();
        String requestJSON = new ConsumerCreateRequest(streamName, config).toJson();
        String subj = durable == null ? String.format("CONSUMER.CREATE.%s", streamName) : String.format("CONSUMER.DURABLE.CREATE.%s.%s", streamName, durable);
        Message resp = this.makeRequestResponseRequired(subj, requestJSON.getBytes(), this.conn.getOptions().getConnectionTimeout());
        return (ConsumerInfo)new ConsumerInfo(resp).throwOnHasError();
    }

    protected Message makeRequestResponseRequired(String subject, byte[] bytes, Duration timeout) throws IOException {
        try {
            return this.responseRequired(this.conn.request(this.prependPrefix(subject), bytes, timeout));
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    protected Message makeInternalRequestResponseRequired(String subject, Headers headers, byte[] data, boolean utf8mode, Duration timeout, boolean cancelOn503) throws IOException {
        try {
            return this.responseRequired(this.conn.requestInternal(subject, headers, data, utf8mode, timeout, cancelOn503));
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    protected Message responseRequired(Message respMessage) throws IOException {
        if (respMessage == null) {
            throw new IOException("Timeout or no response waiting for NATS JetStream server");
        }
        return respMessage;
    }

    protected String prependPrefix(String subject) {
        return this.jso.getPrefix() + subject;
    }
}

