/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.JetStreamApiException;
import io.nats.client.JetStreamManagement;
import io.nats.client.JetStreamOptions;
import io.nats.client.Message;
import io.nats.client.PurgeOptions;
import io.nats.client.api.AccountStatistics;
import io.nats.client.api.ConsumerConfiguration;
import io.nats.client.api.ConsumerInfo;
import io.nats.client.api.MessageInfo;
import io.nats.client.api.PurgeResponse;
import io.nats.client.api.StreamConfiguration;
import io.nats.client.api.StreamInfo;
import io.nats.client.api.SuccessApiResponse;
import io.nats.client.impl.ConsumerListReader;
import io.nats.client.impl.ConsumerNamesReader;
import io.nats.client.impl.NatsConnection;
import io.nats.client.impl.NatsJetStreamImplBase;
import io.nats.client.impl.StreamListReader;
import io.nats.client.impl.StreamNamesReader;
import io.nats.client.support.JsonUtils;
import io.nats.client.support.Validator;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class NatsJetStreamManagement
extends NatsJetStreamImplBase
implements JetStreamManagement {
    public NatsJetStreamManagement(NatsConnection connection, JetStreamOptions jsOptions) throws IOException {
        super(connection, jsOptions);
    }

    @Override
    public AccountStatistics getAccountStatistics() throws IOException, JetStreamApiException {
        Message resp = this.makeRequestResponseRequired("INFO", null, this.jso.getRequestTimeout());
        return (AccountStatistics)new AccountStatistics(resp).throwOnHasError();
    }

    @Override
    public StreamInfo addStream(StreamConfiguration config) throws IOException, JetStreamApiException {
        return this.addOrUpdateStream(config, "STREAM.CREATE.%s");
    }

    @Override
    public StreamInfo updateStream(StreamConfiguration config) throws IOException, JetStreamApiException {
        return this.addOrUpdateStream(config, "STREAM.UPDATE.%s");
    }

    private StreamInfo addOrUpdateStream(StreamConfiguration config, String template) throws IOException, JetStreamApiException {
        Validator.validateNotNull(config, "Configuration");
        String streamName = config.getName();
        if (Validator.nullOrEmpty(streamName)) {
            throw new IllegalArgumentException("Configuration must have a valid stream name");
        }
        String subj = String.format(template, streamName);
        Message resp = this.makeRequestResponseRequired(subj, config.toJson().getBytes(StandardCharsets.UTF_8), this.jso.getRequestTimeout());
        return (StreamInfo)new StreamInfo(resp).throwOnHasError();
    }

    @Override
    public boolean deleteStream(String streamName) throws IOException, JetStreamApiException {
        Validator.validateNotNull(streamName, "Stream Name");
        String subj = String.format("STREAM.DELETE.%s", streamName);
        Message resp = this.makeRequestResponseRequired(subj, null, this.jso.getRequestTimeout());
        return ((SuccessApiResponse)new SuccessApiResponse(resp).throwOnHasError()).getSuccess();
    }

    @Override
    public StreamInfo getStreamInfo(String streamName) throws IOException, JetStreamApiException {
        Validator.validateNotNull(streamName, "Stream Name");
        String subj = String.format("STREAM.INFO.%s", streamName);
        Message resp = this.makeRequestResponseRequired(subj, null, this.jso.getRequestTimeout());
        return (StreamInfo)new StreamInfo(resp).throwOnHasError();
    }

    @Override
    public PurgeResponse purgeStream(String streamName) throws IOException, JetStreamApiException {
        String subj = String.format("STREAM.PURGE.%s", streamName);
        Message resp = this.makeRequestResponseRequired(subj, null, this.jso.getRequestTimeout());
        return (PurgeResponse)new PurgeResponse(resp).throwOnHasError();
    }

    @Override
    public PurgeResponse purgeStream(String streamName, PurgeOptions options) throws IOException, JetStreamApiException {
        String subj = String.format("STREAM.PURGE.%s", streamName);
        byte[] body = options.toJson().getBytes(StandardCharsets.UTF_8);
        Message resp = this.makeRequestResponseRequired(subj, body, this.jso.getRequestTimeout());
        return (PurgeResponse)new PurgeResponse(resp).throwOnHasError();
    }

    @Override
    public ConsumerInfo addOrUpdateConsumer(String streamName, ConsumerConfiguration config) throws IOException, JetStreamApiException {
        Validator.validateStreamName(streamName, true);
        Validator.validateNotNull(config, "Config");
        Validator.validateNotNull(config.getDurable(), "Durable");
        return this.addOrUpdateConsumerInternal(streamName, config);
    }

    @Override
    public boolean deleteConsumer(String streamName, String consumer) throws IOException, JetStreamApiException {
        Validator.validateNotNull(streamName, "Stream Name");
        Validator.validateNotNull(consumer, "consumer");
        String subj = String.format("CONSUMER.DELETE.%s.%s", streamName, consumer);
        Message resp = this.makeRequestResponseRequired(subj, null, this.jso.getRequestTimeout());
        return ((SuccessApiResponse)new SuccessApiResponse(resp).throwOnHasError()).getSuccess();
    }

    @Override
    public ConsumerInfo getConsumerInfo(String streamName, String consumer) throws IOException, JetStreamApiException {
        return super.getConsumerInfo(streamName, consumer);
    }

    @Override
    public List<String> getConsumerNames(String streamName) throws IOException, JetStreamApiException {
        return this.getConsumerNames(streamName, null);
    }

    private List<String> getConsumerNames(String streamName, String filter) throws IOException, JetStreamApiException {
        String subj = String.format("CONSUMER.NAMES.%s", streamName);
        ConsumerNamesReader cnr = new ConsumerNamesReader();
        while (cnr.hasMore()) {
            Message resp = this.makeRequestResponseRequired(subj, cnr.nextJson(filter), this.jso.getRequestTimeout());
            cnr.process(resp);
        }
        return cnr.getStrings();
    }

    @Override
    public List<ConsumerInfo> getConsumers(String streamName) throws IOException, JetStreamApiException {
        String subj = String.format("CONSUMER.LIST.%s", streamName);
        ConsumerListReader clg = new ConsumerListReader();
        while (clg.hasMore()) {
            Message resp = this.makeRequestResponseRequired(subj, clg.nextJson(), this.jso.getRequestTimeout());
            clg.process(resp);
        }
        return clg.getConsumers();
    }

    @Override
    public List<String> getStreamNames() throws IOException, JetStreamApiException {
        StreamNamesReader snr = new StreamNamesReader();
        while (snr.hasMore()) {
            Message resp = this.makeRequestResponseRequired("STREAM.NAMES", snr.nextJson(), this.jso.getRequestTimeout());
            snr.process(resp);
        }
        return snr.getStrings();
    }

    @Override
    public List<StreamInfo> getStreams() throws IOException, JetStreamApiException {
        StreamListReader slg = new StreamListReader();
        while (slg.hasMore()) {
            Message resp = this.makeRequestResponseRequired("STREAM.LIST", slg.nextJson(), this.jso.getRequestTimeout());
            slg.process(resp);
        }
        return slg.getStreams();
    }

    @Override
    public MessageInfo getMessage(String streamName, long seq) throws IOException, JetStreamApiException {
        Validator.validateNotNull(streamName, "Stream Name");
        String subj = String.format("STREAM.MSG.GET.%s", streamName);
        Message resp = this.makeRequestResponseRequired(subj, JsonUtils.simpleMessageBody("seq", seq), this.jso.getRequestTimeout());
        return (MessageInfo)new MessageInfo(resp).throwOnHasError();
    }

    @Override
    public boolean deleteMessage(String streamName, long seq) throws IOException, JetStreamApiException {
        Validator.validateNotNull(streamName, "Stream Name");
        String subj = String.format("STREAM.MSG.DELETE.%s", streamName);
        Message resp = this.makeRequestResponseRequired(subj, JsonUtils.simpleMessageBody("seq", seq), this.jso.getRequestTimeout());
        return ((SuccessApiResponse)new SuccessApiResponse(resp).throwOnHasError()).getSuccess();
    }
}

