/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.JetStream;
import io.nats.client.JetStreamApiException;
import io.nats.client.JetStreamOptions;
import io.nats.client.KeyValue;
import io.nats.client.Message;
import io.nats.client.api.KvEntry;
import io.nats.client.api.MessageInfo;
import io.nats.client.api.PublishAck;
import io.nats.client.impl.Headers;
import io.nats.client.impl.NatsConnection;
import io.nats.client.impl.NatsJetStream;
import io.nats.client.impl.NatsJetStreamImplBase;
import io.nats.client.impl.NatsMessage;
import io.nats.client.support.JsonUtils;
import io.nats.client.support.NatsKeyValueUtil;
import io.nats.client.support.Validator;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class NatsKeyValue
extends NatsJetStreamImplBase
implements KeyValue {
    private static final Headers HEADERS_DELETE_INSTRUCTION = NatsKeyValueUtil.addDeleteHeader(new Headers());
    private final String bucket;
    private final String stream;
    private final JetStream js;

    public NatsKeyValue(String bucket, NatsConnection connection, JetStreamOptions jsOptions) throws IOException {
        super(connection, jsOptions);
        this.bucket = Validator.validateBucketNameRequired(bucket);
        this.stream = NatsKeyValueUtil.streamName(this.bucket);
        this.js = new NatsJetStream(connection, jsOptions);
    }

    @Override
    public byte[] getValue(String key) throws IOException, JetStreamApiException {
        KvEntry entry = this.getEntry(key);
        return entry == null ? null : entry.getData();
    }

    @Override
    public String getStringValue(String key) throws IOException, JetStreamApiException {
        byte[] value = this.getValue(key);
        return value == null ? null : new String(value, StandardCharsets.UTF_8);
    }

    @Override
    public Long getLongValue(String key) throws IOException, JetStreamApiException {
        byte[] value = this.getValue(key);
        return value == null ? null : Long.valueOf(Long.parseLong(new String(value, StandardCharsets.US_ASCII)));
    }

    @Override
    public KvEntry getEntry(String key) throws IOException, JetStreamApiException {
        Validator.validateKeyRequired(key);
        String subj = String.format("STREAM.MSG.GET.%s", this.stream);
        Message resp = this.makeRequestResponseRequired(subj, JsonUtils.simpleMessageBody("last_by_subj", NatsKeyValueUtil.keySubject(this.bucket, key)), this.jso.getRequestTimeout());
        MessageInfo mi = new MessageInfo(resp);
        if (mi.hasError()) {
            if (mi.getApiErrorCode() == 10037) {
                return null;
            }
            mi.throwOnHasError();
        }
        return new KvEntry(mi);
    }

    @Override
    public long put(String key, byte[] value) throws IOException, JetStreamApiException {
        Validator.validateKeyRequired(key);
        PublishAck pa = this.js.publish(NatsMessage.builder().subject(NatsKeyValueUtil.keySubject(this.bucket, key)).data(value).build());
        return pa.getSeqno();
    }

    @Override
    public long put(String key, String value) throws IOException, JetStreamApiException {
        return this.put(key, value.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public long put(String key, long value) throws IOException, JetStreamApiException {
        return this.put(key, Long.toString(value).getBytes(StandardCharsets.US_ASCII));
    }

    @Override
    public long delete(String key) throws IOException, JetStreamApiException {
        Validator.validateKeyRequired(key);
        PublishAck pa = this.js.publish(NatsMessage.builder().subject(NatsKeyValueUtil.keySubject(this.bucket, key)).headers(HEADERS_DELETE_INSTRUCTION).build());
        return pa.getSeqno();
    }
}

