/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import io.nats.client.support.JsonSerializable;
import io.nats.client.support.JsonUtils;
import io.nats.client.support.Validator;

public class PurgeOptions
implements JsonSerializable {
    protected final String subject;
    protected final long seq;
    protected final long keep;

    private PurgeOptions(String subject, long seq, long keep) {
        this.subject = subject;
        this.seq = seq;
        this.keep = keep;
    }

    @Override
    public String toJson() {
        StringBuilder sb = JsonUtils.beginJson();
        JsonUtils.addField(sb, "filter", this.subject);
        JsonUtils.addField(sb, "seq", this.seq);
        JsonUtils.addField(sb, "keep", this.keep);
        return JsonUtils.endJson(sb).toString();
    }

    public String getSubject() {
        return this.subject;
    }

    public long getSeq() {
        return this.seq;
    }

    public long getKeep() {
        return this.keep;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder subject() {
        return new Builder();
    }

    public static class Builder {
        private String subject;
        private long seq;
        private long keep;

        public Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public Builder seq(long seq) {
            this.seq = seq;
            return this;
        }

        public Builder keep(long keep) {
            this.keep = keep;
            return this;
        }

        public PurgeOptions build() {
            Validator.validateSubject(this.subject, false);
            if (this.seq > 0L && this.keep > 0L) {
                throw new IllegalArgumentException("seq and keep are mutually exclusive.");
            }
            return new PurgeOptions(this.subject, this.seq, this.keep);
        }
    }
}

