/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.api.StorageType;
import io.nats.client.api.StreamConfiguration;
import io.nats.client.support.NatsKeyValueUtil;
import io.nats.client.support.Validator;
import java.time.Duration;

public class BucketConfiguration {
    private final StreamConfiguration sc;
    private final String name;

    static BucketConfiguration instance(String json) {
        return new BucketConfiguration(StreamConfiguration.instance(json));
    }

    BucketConfiguration(StreamConfiguration sc) {
        this.sc = sc;
        this.name = NatsKeyValueUtil.extractBucketName(sc.getName());
    }

    public StreamConfiguration getBackingConfig() {
        return this.sc;
    }

    public String getName() {
        return this.name;
    }

    public long getMaxValues() {
        return this.sc.getMaxMsgs();
    }

    public long getMaxHistory() {
        return this.sc.getMaxMsgsPerSubject();
    }

    public long getMaxBucketSize() {
        return this.sc.getMaxBytes();
    }

    public long getMaxValueSize() {
        return this.sc.getMaxMsgSize();
    }

    public Duration getTtl() {
        return this.sc.getMaxAge();
    }

    public StorageType getStorageType() {
        return this.sc.getStorageType();
    }

    public int getReplicas() {
        return this.sc.getReplicas();
    }

    public Duration getDuplicateWindow() {
        return this.sc.getDuplicateWindow();
    }

    public String toString() {
        return "BucketConfiguration{name='" + this.name + '\'' + ", maxValues=" + this.getMaxValues() + ", maxHistory=" + this.getMaxHistory() + ", maxBucketSize=" + this.getMaxBucketSize() + ", maxValueSize=" + this.getMaxValueSize() + ", ttl=" + this.getTtl() + ", storageType=" + (Object)((Object)this.getStorageType()) + ", replicas=" + this.getReplicas() + ", duplicateWindow=" + this.getDuplicateWindow() + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(BucketConfiguration bc) {
        return new Builder(bc);
    }

    public static class Builder {
        String name;
        StreamConfiguration.Builder scBuilder;

        public Builder() {
            this(null);
        }

        public Builder(BucketConfiguration bc) {
            if (bc == null) {
                this.scBuilder = new StreamConfiguration.Builder();
                this.maxHistory(1L);
            } else {
                this.scBuilder = new StreamConfiguration.Builder(bc.sc);
                this.name = bc.sc.getName().substring(NatsKeyValueUtil.KV_STREAM_PREFIX_LEN);
            }
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder maxValues(long maxValues) {
            this.scBuilder.maxMessages(Validator.validateMaxBucketValues(maxValues));
            return this;
        }

        public Builder maxHistory(long maxHistory) {
            this.scBuilder.maxMessagesPerSubject(Validator.validateMaxValuesPerKey(maxHistory));
            return this;
        }

        public Builder maxBucketSize(long maxBucketSize) {
            this.scBuilder.maxBytes(Validator.validateMaxBucketBytes(maxBucketSize));
            return this;
        }

        public Builder maxValueSize(long maxValueSize) {
            this.scBuilder.maxMsgSize(Validator.validateMaxValueSize(maxValueSize));
            return this;
        }

        public Builder ttl(Duration ttl) {
            this.scBuilder.maxAge(ttl);
            return this;
        }

        public Builder storageType(StorageType storageType) {
            this.scBuilder.storageType(storageType);
            return this;
        }

        public Builder replicas(int replicas) {
            this.scBuilder.replicas(replicas);
            return this;
        }

        public Builder duplicateWindow(Duration window) {
            this.scBuilder.duplicateWindow(window);
            return this;
        }

        public Builder duplicateWindow(long windowMillis) {
            this.scBuilder.duplicateWindow(windowMillis);
            return this;
        }

        public BucketConfiguration build() {
            this.name = Validator.validateBucketNameRequired(this.name);
            this.scBuilder.name(NatsKeyValueUtil.streamName(this.name));
            this.scBuilder.subjects(NatsKeyValueUtil.streamSubject(this.name));
            return new BucketConfiguration(this.scBuilder.build());
        }
    }
}

