/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.api.AckPolicy;
import io.nats.client.api.DeliverPolicy;
import io.nats.client.api.ReplayPolicy;
import io.nats.client.support.ApiConstants;
import io.nats.client.support.JsonSerializable;
import io.nats.client.support.JsonUtils;
import io.nats.client.support.Validator;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.regex.Matcher;

public class ConsumerConfiguration
implements JsonSerializable {
    public static final Duration MIN_ACK_WAIT = Duration.ofNanos(1L);
    public static final Duration MIN_DEFAULT_IDLE_HEARTBEAT = Duration.ZERO;
    public static final Duration DEFAULT_ACK_WAIT = Duration.ofSeconds(30L);
    private final DeliverPolicy deliverPolicy;
    private final AckPolicy ackPolicy;
    private final ReplayPolicy replayPolicy;
    private final String description;
    private final String durable;
    private final String deliverSubject;
    private final String deliverGroup;
    private final long startSeq;
    private final ZonedDateTime startTime;
    private final Duration ackWait;
    private final long maxDeliver;
    private final String filterSubject;
    private final String sampleFrequency;
    private final long rateLimit;
    private final long maxAckPending;
    private final Duration idleHeartbeat;
    private final boolean flowControl;
    private final long maxPullWaiting;

    ConsumerConfiguration(String json) {
        Matcher m = ApiConstants.DELIVER_POLICY_RE.matcher(json);
        this.deliverPolicy = m.find() ? DeliverPolicy.get(m.group(1)) : DeliverPolicy.All;
        m = ApiConstants.ACK_POLICY_RE.matcher(json);
        this.ackPolicy = m.find() ? AckPolicy.get(m.group(1)) : AckPolicy.Explicit;
        m = ApiConstants.REPLAY_POLICY_RE.matcher(json);
        this.replayPolicy = m.find() ? ReplayPolicy.get(m.group(1)) : ReplayPolicy.Instant;
        this.description = JsonUtils.readString(json, ApiConstants.DESCRIPTION_RE);
        this.durable = JsonUtils.readString(json, ApiConstants.DURABLE_NAME_RE);
        this.deliverSubject = JsonUtils.readString(json, ApiConstants.DELIVER_SUBJECT_RE);
        this.deliverGroup = JsonUtils.readString(json, ApiConstants.DELIVER_GROUP_RE);
        this.startSeq = JsonUtils.readLong(json, ApiConstants.OPT_START_SEQ_RE, 0L);
        this.startTime = JsonUtils.readDate(json, ApiConstants.OPT_START_TIME_RE);
        this.ackWait = JsonUtils.readNanos(json, ApiConstants.ACK_WAIT_RE, Duration.ofSeconds(30L));
        this.maxDeliver = JsonUtils.readLong(json, ApiConstants.MAX_DELIVER_RE, -1L);
        this.filterSubject = JsonUtils.readString(json, ApiConstants.FILTER_SUBJECT_RE);
        this.sampleFrequency = JsonUtils.readString(json, ApiConstants.SAMPLE_FREQ_RE);
        this.rateLimit = JsonUtils.readLong(json, ApiConstants.RATE_LIMIT_BPS_RE, 0L);
        this.maxAckPending = JsonUtils.readLong(json, ApiConstants.MAX_ACK_PENDING_RE, 0L);
        this.idleHeartbeat = JsonUtils.readNanos(json, ApiConstants.IDLE_HEARTBEAT_RE, Duration.ZERO);
        this.flowControl = JsonUtils.readBoolean(json, ApiConstants.FLOW_CONTROL_RE);
        this.maxPullWaiting = JsonUtils.readLong(json, ApiConstants.MAX_PULL_WAITING_RE, 0L);
    }

    private ConsumerConfiguration(String description, String durable, DeliverPolicy deliverPolicy, long startSeq, ZonedDateTime startTime, AckPolicy ackPolicy, Duration ackWait, long maxDeliver, String filterSubject, ReplayPolicy replayPolicy, String sampleFrequency, long rateLimit, String deliverSubject, String deliverGroup, long maxAckPending, Duration idleHeartbeat, boolean flowControl, long maxPullWaiting) {
        this.description = description;
        this.durable = durable;
        this.deliverPolicy = deliverPolicy;
        this.startSeq = startSeq;
        this.startTime = startTime;
        this.ackPolicy = ackPolicy;
        this.ackWait = ackWait;
        this.maxDeliver = maxDeliver;
        this.filterSubject = filterSubject;
        this.replayPolicy = replayPolicy;
        this.sampleFrequency = sampleFrequency;
        this.rateLimit = rateLimit;
        this.deliverSubject = deliverSubject;
        this.deliverGroup = deliverGroup;
        this.maxAckPending = maxAckPending;
        this.idleHeartbeat = idleHeartbeat;
        this.flowControl = flowControl;
        this.maxPullWaiting = maxPullWaiting;
    }

    @Override
    public String toJson() {
        StringBuilder sb = JsonUtils.beginJson();
        JsonUtils.addField(sb, "description", this.description);
        JsonUtils.addField(sb, "durable_name", this.durable);
        JsonUtils.addField(sb, "deliver_subject", this.deliverSubject);
        JsonUtils.addField(sb, "deliver_group", this.deliverGroup);
        JsonUtils.addField(sb, "deliver_policy", this.deliverPolicy.toString());
        JsonUtils.addField(sb, "opt_start_seq", this.startSeq);
        JsonUtils.addField(sb, "opt_start_time", this.startTime);
        JsonUtils.addField(sb, "ack_policy", this.ackPolicy.toString());
        JsonUtils.addFieldAsNanos(sb, "ack_wait", this.ackWait);
        JsonUtils.addField(sb, "max_deliver", this.maxDeliver);
        JsonUtils.addField(sb, "max_ack_pending", this.maxAckPending);
        JsonUtils.addField(sb, "filter_subject", this.filterSubject);
        JsonUtils.addField(sb, "replay_policy", this.replayPolicy.toString());
        JsonUtils.addField(sb, "sample_freq", this.sampleFrequency);
        JsonUtils.addField(sb, "rate_limit_bps", this.rateLimit);
        JsonUtils.addFieldAsNanos(sb, "idle_heartbeat", this.idleHeartbeat);
        JsonUtils.addField(sb, "flow_control", this.flowControl);
        JsonUtils.addField(sb, "max_waiting", this.maxPullWaiting);
        return JsonUtils.endJson(sb).toString();
    }

    public String getDescription() {
        return this.description;
    }

    public String getDurable() {
        return this.durable;
    }

    public String getDeliverSubject() {
        return this.deliverSubject;
    }

    public String getDeliverGroup() {
        return this.deliverGroup;
    }

    public DeliverPolicy getDeliverPolicy() {
        return this.deliverPolicy;
    }

    public long getStartSequence() {
        return this.startSeq;
    }

    public ZonedDateTime getStartTime() {
        return this.startTime;
    }

    public AckPolicy getAckPolicy() {
        return this.ackPolicy;
    }

    public Duration getAckWait() {
        return this.ackWait;
    }

    public long getMaxDeliver() {
        return this.maxDeliver;
    }

    public String getFilterSubject() {
        return this.filterSubject;
    }

    public ReplayPolicy getReplayPolicy() {
        return this.replayPolicy;
    }

    public long getRateLimit() {
        return this.rateLimit;
    }

    public long getMaxAckPending() {
        return this.maxAckPending;
    }

    public String getSampleFrequency() {
        return this.sampleFrequency;
    }

    public Duration getIdleHeartbeat() {
        return this.idleHeartbeat;
    }

    public boolean getFlowControl() {
        return this.flowControl;
    }

    public long getMaxPullWaiting() {
        return this.maxPullWaiting;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ConsumerConfiguration cc) {
        return cc == null ? new Builder() : new Builder(cc);
    }

    public String toString() {
        return "ConsumerConfiguration{description='" + this.description + '\'' + ", durable='" + this.durable + '\'' + ", deliverPolicy=" + (Object)((Object)this.deliverPolicy) + ", deliverSubject='" + this.deliverSubject + '\'' + ", deliverGroup='" + this.deliverGroup + '\'' + ", startSeq=" + this.startSeq + ", startTime=" + this.startTime + ", ackPolicy=" + (Object)((Object)this.ackPolicy) + ", ackWait=" + this.ackWait + ", maxDeliver=" + this.maxDeliver + ", filterSubject='" + this.filterSubject + '\'' + ", replayPolicy=" + (Object)((Object)this.replayPolicy) + ", sampleFrequency='" + this.sampleFrequency + '\'' + ", rateLimit=" + this.rateLimit + ", maxAckPending=" + this.maxAckPending + ", idleHeartbeat=" + this.idleHeartbeat + ", flowControl=" + this.flowControl + ", maxPullWaiting=" + this.maxPullWaiting + '}';
    }

    public static class Builder {
        private String description = null;
        private String durable = null;
        private DeliverPolicy deliverPolicy = DeliverPolicy.All;
        private long startSeq = 0L;
        private ZonedDateTime startTime = null;
        private AckPolicy ackPolicy = AckPolicy.Explicit;
        private Duration ackWait = Duration.ofSeconds(30L);
        private long maxDeliver = -1L;
        private String filterSubject = null;
        private ReplayPolicy replayPolicy = ReplayPolicy.Instant;
        private String sampleFrequency = null;
        private long rateLimit = 0L;
        private String deliverSubject = null;
        private String deliverGroup = null;
        private long maxAckPending = 0L;
        private Duration idleHeartbeat = Duration.ZERO;
        private boolean flowControl;
        private long maxPullWaiting = 0L;

        public String getDurable() {
            return this.durable;
        }

        public String getDeliverSubject() {
            return this.deliverSubject;
        }

        public String getDeliverGroup() {
            return this.deliverGroup;
        }

        public String getFilterSubject() {
            return this.filterSubject;
        }

        public long getMaxAckPending() {
            return this.maxAckPending;
        }

        public AckPolicy getAckPolicy() {
            return this.ackPolicy;
        }

        public Builder() {
        }

        public Builder(ConsumerConfiguration cc) {
            this.description = cc.description;
            this.durable = cc.durable;
            this.deliverPolicy = cc.deliverPolicy;
            this.startSeq = cc.startSeq;
            this.startTime = cc.startTime;
            this.ackPolicy = cc.ackPolicy;
            this.ackWait = cc.ackWait;
            this.maxDeliver = cc.maxDeliver;
            this.filterSubject = cc.filterSubject;
            this.replayPolicy = cc.replayPolicy;
            this.sampleFrequency = cc.sampleFrequency;
            this.rateLimit = cc.rateLimit;
            this.deliverSubject = cc.deliverSubject;
            this.deliverGroup = cc.deliverGroup;
            this.maxAckPending = cc.maxAckPending;
            this.idleHeartbeat = cc.idleHeartbeat;
            this.flowControl = cc.flowControl;
            this.maxPullWaiting = cc.maxPullWaiting;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder durable(String durable) {
            this.durable = Validator.emptyAsNull(durable);
            return this;
        }

        public Builder deliverPolicy(DeliverPolicy policy) {
            this.deliverPolicy = policy == null ? DeliverPolicy.All : policy;
            return this;
        }

        public Builder deliverSubject(String subject) {
            this.deliverSubject = Validator.emptyAsNull(subject);
            return this;
        }

        public Builder deliverGroup(String group) {
            this.deliverGroup = Validator.emptyAsNull(group);
            return this;
        }

        public Builder startSequence(long sequence) {
            this.startSeq = sequence;
            return this;
        }

        public Builder startTime(ZonedDateTime startTime) {
            this.startTime = startTime;
            return this;
        }

        public Builder ackPolicy(AckPolicy policy) {
            this.ackPolicy = policy == null ? AckPolicy.Explicit : policy;
            return this;
        }

        public Builder ackWait(Duration timeout) {
            this.ackWait = Validator.ensureNotNullAndNotLessThanMin(timeout, MIN_ACK_WAIT, DEFAULT_ACK_WAIT);
            return this;
        }

        public Builder ackWait(long timeoutMillis) {
            this.ackWait = Validator.ensureDurationNotLessThanMin(timeoutMillis, MIN_ACK_WAIT, DEFAULT_ACK_WAIT);
            return this;
        }

        public Builder maxDeliver(long maxDeliver) {
            this.maxDeliver = maxDeliver;
            return this;
        }

        public Builder filterSubject(String filterSubject) {
            this.filterSubject = Validator.emptyAsNull(filterSubject);
            return this;
        }

        public Builder replayPolicy(ReplayPolicy policy) {
            this.replayPolicy = policy == null ? ReplayPolicy.Instant : policy;
            return this;
        }

        public Builder sampleFrequency(String frequency) {
            this.sampleFrequency = Validator.emptyAsNull(frequency);
            return this;
        }

        public Builder rateLimit(int msgsPerSecond) {
            this.rateLimit = msgsPerSecond;
            return this;
        }

        public Builder maxAckPending(long maxAckPending) {
            this.maxAckPending = Validator.validateGtEqZero(maxAckPending, "Max Ack Pending");
            return this;
        }

        public Builder idleHeartbeat(Duration idleHeartbeat) {
            this.idleHeartbeat = Validator.ensureNotNullAndNotLessThanMin(idleHeartbeat, MIN_DEFAULT_IDLE_HEARTBEAT, MIN_DEFAULT_IDLE_HEARTBEAT);
            return this;
        }

        public Builder idleHeartbeat(long idleHeartbeatMillis) {
            this.idleHeartbeat = Validator.ensureDurationNotLessThanMin(idleHeartbeatMillis, MIN_DEFAULT_IDLE_HEARTBEAT, MIN_DEFAULT_IDLE_HEARTBEAT);
            return this;
        }

        public Builder flowControl(boolean flowControl) {
            this.flowControl = flowControl;
            return this;
        }

        public Builder maxPullWaiting(long maxPullWaiting) {
            this.maxPullWaiting = Validator.validateGtEqZero(maxPullWaiting, "Max Pull Waiting");
            return this;
        }

        public ConsumerConfiguration build() {
            return new ConsumerConfiguration(this.description, this.durable, this.deliverPolicy, this.startSeq, this.startTime, this.ackPolicy, this.ackWait, this.maxDeliver, this.filterSubject, this.replayPolicy, this.sampleFrequency, this.rateLimit, this.deliverSubject, this.deliverGroup, this.maxAckPending, this.idleHeartbeat, this.flowControl, this.maxPullWaiting);
        }
    }
}

