/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.support;

import io.nats.client.NKey;
import io.nats.client.support.Encoding;
import io.nats.client.support.JsonSerializable;
import io.nats.client.support.JsonUtils;
import io.nats.client.support.Validator;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;

public abstract class JwtUtils {
    private static final String ENCODED_CLAIM_HEADER = Encoding.toBase64Url("{\"typ\":\"JWT\", \"alg\":\"ed25519-nkey\"}");
    public static final String NATS_USER_JWT_FORMAT = "-----BEGIN NATS USER JWT-----\n%s\n------END NATS USER JWT------\n\n************************* IMPORTANT *************************\n    NKEY Seed printed below can be used to sign and prove identity.\n    NKEYs are sensitive and should be treated as secrets.\n\n-----BEGIN USER NKEY SEED-----\n%s\n------END USER NKEY SEED------\n\n*************************************************************\n";

    private JwtUtils() {
    }

    public static String issueUserJWT(NKey signingKey, String accountId, String publicUserKey) throws GeneralSecurityException, IOException {
        return JwtUtils.issueUserJWT(signingKey, accountId, publicUserKey, null, null, new String[0]);
    }

    public static String issueUserJWT(NKey signingKey, String accountId, String publicUserKey, String name) throws GeneralSecurityException, IOException {
        return JwtUtils.issueUserJWT(signingKey, accountId, publicUserKey, name, null, new String[0]);
    }

    public static String issueUserJWT(NKey signingKey, String accountId, String publicUserKey, String name, Duration expiration, String ... tags) throws GeneralSecurityException, IOException {
        return JwtUtils.issueUserJWT(signingKey, accountId, publicUserKey, name, expiration, tags, System.currentTimeMillis() / 1000L);
    }

    protected static String issueUserJWT(NKey signingKey, String accountId, String publicUserKey, String name, Duration expiration, String[] tags, long issuedAt) throws GeneralSecurityException, IOException {
        if (signingKey.getType() != NKey.Type.ACCOUNT) {
            throw new IllegalArgumentException("issueUserJWT requires an account key for the signingKey parameter, but got " + (Object)((Object)signingKey.getType()));
        }
        NKey accountKey = NKey.fromPublicKey(accountId.toCharArray());
        if (accountKey.getType() != NKey.Type.ACCOUNT) {
            throw new IllegalArgumentException("issueUserJWT requires an account key for the accountId parameter, but got " + (Object)((Object)accountKey.getType()));
        }
        NKey userKey = NKey.fromPublicKey(publicUserKey.toCharArray());
        if (userKey.getType() != NKey.Type.USER) {
            throw new IllegalArgumentException("issueUserJWT requires a user key for the publicUserKey, but got " + (Object)((Object)userKey.getType()));
        }
        String accSigningKeyPub = new String(signingKey.getPublicKey());
        Claim claim = new Claim();
        claim.exp = expiration;
        claim.iat = issuedAt;
        claim.iss = accSigningKeyPub;
        claim.name = Validator.nullOrEmpty(name) ? publicUserKey : name;
        claim.sub = publicUserKey;
        claim.nats = new Nats();
        claim.nats.issuerAccount = accountId;
        claim.nats.tags = tags;
        String claimJson = claim.toJson();
        MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
        byte[] encoded = sha256.digest(claimJson.getBytes(StandardCharsets.UTF_8));
        claim.jti = new String(Encoding.base32Encode(encoded));
        claimJson = claim.toJson();
        String encBody = Encoding.toBase64Url(claimJson);
        byte[] sig = (ENCODED_CLAIM_HEADER + "." + encBody).getBytes(StandardCharsets.UTF_8);
        String encSig = Encoding.toBase64Url(signingKey.sign(sig));
        return ENCODED_CLAIM_HEADER + "." + encBody + "." + encSig;
    }

    static class Claim
    implements JsonSerializable {
        Duration exp;
        long iat;
        String iss;
        String jti;
        String name;
        Nats nats;
        String sub;

        Claim() {
        }

        @Override
        public String toJson() {
            StringBuilder sb = JsonUtils.beginJson();
            if (this.exp != null && !this.exp.isZero() && !this.exp.isNegative()) {
                long seconds = this.exp.toMillis() / 1000L;
                JsonUtils.addField(sb, "exp", this.iat + seconds);
            }
            JsonUtils.addField(sb, "iat", this.iat);
            JsonUtils.addFieldEvenEmpty(sb, "jti", this.jti);
            JsonUtils.addField(sb, "iss", this.iss);
            JsonUtils.addField(sb, "name", this.name);
            JsonUtils.addField(sb, "nats", this.nats);
            JsonUtils.addField(sb, "sub", this.sub);
            return JsonUtils.endJson(sb).toString();
        }
    }

    static class Nats
    implements JsonSerializable {
        String issuerAccount;
        String[] tags;

        Nats() {
        }

        @Override
        public String toJson() {
            StringBuilder sb = JsonUtils.beginJson();
            JsonUtils.addField(sb, "issuer_account", this.issuerAccount);
            JsonUtils.addStrings(sb, "tags", null == this.tags ? Collections.emptyList() : Arrays.asList(this.tags));
            JsonUtils.addField(sb, "type", "user");
            JsonUtils.addField(sb, "version", 2L);
            return JsonUtils.endJson(sb).toString();
        }
    }
}

