/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.Dispatcher;
import io.nats.client.JetStream;
import io.nats.client.JetStreamApiException;
import io.nats.client.JetStreamOptions;
import io.nats.client.JetStreamSubscription;
import io.nats.client.Message;
import io.nats.client.MessageHandler;
import io.nats.client.PublishOptions;
import io.nats.client.PullSubscribeOptions;
import io.nats.client.PushSubscribeOptions;
import io.nats.client.SubscribeOptions;
import io.nats.client.api.AckPolicy;
import io.nats.client.api.ConsumerConfiguration;
import io.nats.client.api.ConsumerInfo;
import io.nats.client.api.PublishAck;
import io.nats.client.impl.AckType;
import io.nats.client.impl.AutoStatusManager;
import io.nats.client.impl.Headers;
import io.nats.client.impl.NatsConnection;
import io.nats.client.impl.NatsDispatcher;
import io.nats.client.impl.NatsJetStreamImplBase;
import io.nats.client.impl.NatsJetStreamSubscription;
import io.nats.client.impl.NatsSubscriptionFactory;
import io.nats.client.impl.PullAutoStatusManager;
import io.nats.client.impl.PushAutoStatusManager;
import io.nats.client.impl.StreamNamesReader;
import io.nats.client.support.JsonUtils;
import io.nats.client.support.NatsJetStreamClientError;
import io.nats.client.support.Validator;
import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;

public class NatsJetStream
extends NatsJetStreamImplBase
implements JetStream {
    public NatsJetStream(NatsConnection connection, JetStreamOptions jsOptions) throws IOException {
        super(connection, jsOptions);
    }

    @Override
    public PublishAck publish(String subject, byte[] body) throws IOException, JetStreamApiException {
        return this.publishSyncInternal(subject, null, body, false, null);
    }

    @Override
    public PublishAck publish(String subject, byte[] body, PublishOptions options) throws IOException, JetStreamApiException {
        return this.publishSyncInternal(subject, null, body, options);
    }

    @Override
    public PublishAck publish(Message message) throws IOException, JetStreamApiException {
        Validator.validateNotNull(message, "Message");
        return this.publishSyncInternal(message.getSubject(), message.getHeaders(), message.getData(), message.isUtf8mode(), null);
    }

    @Override
    public PublishAck publish(Message message, PublishOptions options) throws IOException, JetStreamApiException {
        Validator.validateNotNull(message, "Message");
        return this.publishSyncInternal(message.getSubject(), message.getHeaders(), message.getData(), message.isUtf8mode(), options);
    }

    @Override
    public CompletableFuture<PublishAck> publishAsync(String subject, byte[] body) {
        return this.publishAsyncInternal(subject, null, body, null, null);
    }

    @Override
    public CompletableFuture<PublishAck> publishAsync(String subject, byte[] body, PublishOptions options) {
        return this.publishAsyncInternal(subject, null, body, options, null);
    }

    @Override
    public CompletableFuture<PublishAck> publishAsync(Message message) {
        Validator.validateNotNull(message, "Message");
        return this.publishAsyncInternal(message.getSubject(), message.getHeaders(), message.getData(), message.isUtf8mode(), null, null);
    }

    @Override
    public CompletableFuture<PublishAck> publishAsync(Message message, PublishOptions options) {
        Validator.validateNotNull(message, "Message");
        return this.publishAsyncInternal(message.getSubject(), message.getHeaders(), message.getData(), message.isUtf8mode(), options, null);
    }

    private PublishAck publishSyncInternal(String subject, Headers headers, byte[] data, PublishOptions options) throws IOException, JetStreamApiException {
        return this.publishSyncInternal(subject, headers, data, false, options);
    }

    @Deprecated
    private PublishAck publishSyncInternal(String subject, Headers headers, byte[] data, boolean utf8mode, PublishOptions options) throws IOException, JetStreamApiException {
        Headers merged = this.mergePublishOptions(headers, options);
        if (this.jso.isPublishNoAck()) {
            this.conn.publishInternal(subject, null, merged, data, utf8mode);
            return null;
        }
        Duration timeout = options == null ? this.jso.getRequestTimeout() : options.getStreamTimeout();
        Message resp = this.makeInternalRequestResponseRequired(subject, merged, data, utf8mode, timeout, false);
        return this.processPublishResponse(resp, options);
    }

    private CompletableFuture<PublishAck> publishAsyncInternal(String subject, Headers headers, byte[] data, PublishOptions options, Duration knownTimeout) {
        return this.publishAsyncInternal(subject, headers, data, false, options, knownTimeout);
    }

    @Deprecated
    private CompletableFuture<PublishAck> publishAsyncInternal(String subject, Headers headers, byte[] data, boolean utf8mode, PublishOptions options, Duration knownTimeout) {
        Headers merged = this.mergePublishOptions(headers, options);
        if (this.jso.isPublishNoAck()) {
            this.conn.publishInternal(subject, null, merged, data, utf8mode);
            return null;
        }
        CompletableFuture<Message> future = this.conn.requestFutureInternal(subject, merged, data, utf8mode, knownTimeout, false);
        return future.thenCompose(resp -> {
            try {
                this.responseRequired((Message)resp);
                return CompletableFuture.completedFuture(this.processPublishResponse((Message)resp, options));
            }
            catch (JetStreamApiException | IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private PublishAck processPublishResponse(Message resp, PublishOptions options) throws IOException, JetStreamApiException {
        String pubStream;
        if (resp.isStatusMessage()) {
            throw new IOException("Error Publishing: " + resp.getStatus().getCode() + " " + resp.getStatus().getMessage());
        }
        PublishAck ack = new PublishAck(resp);
        String ackStream = ack.getStream();
        String string = pubStream = options == null ? null : options.getStream();
        if (pubStream != null && !pubStream.equals(ackStream)) {
            throw new IOException("Expected ack from stream " + pubStream + ", received from: " + ackStream);
        }
        return ack;
    }

    private Headers mergePublishOptions(Headers headers, PublishOptions opts) {
        Headers merged;
        Headers headers2 = merged = headers == null ? null : new Headers(headers);
        if (opts != null) {
            merged = this.mergeNum(merged, "Nats-Expected-Last-Sequence", opts.getExpectedLastSequence());
            merged = this.mergeNum(merged, "Nats-Expected-Last-Subject-Sequence", opts.getExpectedLastSubjectSequence());
            merged = this.mergeString(merged, "Nats-Expected-Last-Msg-Id", opts.getExpectedLastMsgId());
            merged = this.mergeString(merged, "Nats-Expected-Stream", opts.getExpectedStream());
            merged = this.mergeString(merged, "Nats-Msg-Id", opts.getMessageId());
        }
        return merged;
    }

    private Headers mergeNum(Headers h, String key, long value) {
        return value > -1L ? this._mergeNum(h, key, Long.toString(value)) : h;
    }

    private Headers mergeString(Headers h, String key, String value) {
        return Validator.nullOrEmpty(value) ? h : this._mergeNum(h, key, value);
    }

    private Headers _mergeNum(Headers h, String key, String value) {
        if (h == null) {
            h = new Headers();
        }
        return h.add(key, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    NatsJetStreamSubscription createSubscription(String subject, String queueName, NatsDispatcher dispatcher, MessageHandler userHandler, boolean autoAck, PushSubscribeOptions pushSubscribeOptions, PullSubscribeOptions pullSubscribeOptions) throws IOException, JetStreamApiException {
        NatsJetStreamSubscription sub;
        String userFilterSubject;
        String qgroup;
        ConsumerConfiguration userCC;
        String stream;
        SubscribeOptions so;
        boolean isPullMode;
        boolean bl = isPullMode = pullSubscribeOptions != null;
        if (isPullMode) {
            so = pullSubscribeOptions;
            stream = pullSubscribeOptions.getStream();
            userCC = so.getConsumerConfiguration();
            qgroup = null;
            Validator.validateNotSupplied(userCC.getDeliverGroup(), NatsJetStreamClientError.JsSubPullCantHaveDeliverGroup);
            Validator.validateNotSupplied(userCC.getDeliverSubject(), NatsJetStreamClientError.JsSubPullCantHaveDeliverSubject);
        } else {
            so = pushSubscribeOptions == null ? PushSubscribeOptions.builder().build() : pushSubscribeOptions;
            stream = so.getStream();
            userCC = so.getConsumerConfiguration();
            Validator.validateNotSupplied(userCC.getMaxPullWaiting(), 0L, NatsJetStreamClientError.JsSubPushCantHaveMaxPullWaiting);
            qgroup = Validator.validateMustMatchIfBothSupplied(userCC.getDeliverGroup(), queueName, NatsJetStreamClientError.JsSubQueueDeliverGroupMismatch);
            if (qgroup != null && userCC.getDeliverGroup() == null) {
                userCC = ConsumerConfiguration.builder(userCC).deliverGroup(qgroup).build();
            }
        }
        if (userCC.isFlowControl() || userCC.getIdleHeartbeat() != null && userCC.getIdleHeartbeat().toMillis() > 0L) {
            if (isPullMode) {
                throw NatsJetStreamClientError.JsSubFcHbNotValidPull.instance();
            }
            if (qgroup != null) {
                throw NatsJetStreamClientError.JsSubFcHbHbNotValidQueue.instance();
            }
        }
        if (stream == null && (stream = this.lookupStreamBySubject(subject)) == null) {
            throw NatsJetStreamClientError.JsSubNoMatchingStreamForSubject.instance();
        }
        ConsumerConfiguration serverCc = null;
        String consumerName = userCC.getDurable();
        String inboxDeliver = userCC.getDeliverSubject();
        if (consumerName != null) {
            ConsumerInfo serverInfo = this.lookupConsumerInfo(stream, consumerName);
            if (serverInfo != null) {
                serverCc = serverInfo.getConsumerConfiguration();
                if (isPullMode) {
                    if (!Validator.nullOrEmpty(serverCc.getDeliverSubject())) {
                        throw NatsJetStreamClientError.JsSubConsumerAlreadyConfiguredAsPush.instance();
                    }
                } else {
                    if (Validator.nullOrEmpty(serverCc.getDeliverSubject())) {
                        throw NatsJetStreamClientError.JsSubConsumerAlreadyConfiguredAsPull.instance();
                    }
                    if (inboxDeliver != null && !inboxDeliver.equals(serverCc.getDeliverSubject())) {
                        throw NatsJetStreamClientError.JsSubExistingDeliverSubjectMismatch.instance();
                    }
                }
                if ((userFilterSubject = userCC.getFilterSubject()) != null && !userFilterSubject.equals(serverCc.getFilterSubject())) {
                    throw NatsJetStreamClientError.JsSubSubjectDoesNotMatchFilter.instance();
                }
                if (serverCc.getDeliverGroup() == null) {
                    if (qgroup != null) throw NatsJetStreamClientError.JsSubExistingConsumerNotQueue.instance();
                    if (serverInfo.isPushBound()) {
                        throw NatsJetStreamClientError.JsSubConsumerAlreadyBound.instance();
                    }
                } else {
                    if (qgroup == null) {
                        throw NatsJetStreamClientError.JsSubExistingConsumerIsQueue.instance();
                    }
                    if (!serverCc.getDeliverGroup().equals(qgroup)) {
                        throw NatsJetStreamClientError.JsSubExistingQueueDoesNotMatchRequestedQueue.instance();
                    }
                }
                if (userCC.wouldBeChangeTo(serverCc)) {
                    throw NatsJetStreamClientError.JsSubExistingConsumerCannotBeModified.instance();
                }
                inboxDeliver = serverCc.getDeliverSubject();
            } else if (so.isBind()) {
                throw NatsJetStreamClientError.JsSubConsumerNotFoundRequiredInBind.instance();
            }
        }
        if (inboxDeliver == null) {
            inboxDeliver = this.conn.createInbox();
        }
        if (serverCc == null) {
            ConsumerConfiguration.Builder ccBuilder = ConsumerConfiguration.builder(userCC);
            if (!isPullMode) {
                ccBuilder.deliverSubject(inboxDeliver);
            }
            ccBuilder.filterSubject((userFilterSubject = userCC.getFilterSubject()) == null ? subject : userFilterSubject);
            ConsumerInfo ci = this.createConsumerInternal(stream, ccBuilder.build());
            consumerName = ci.getName();
            serverCc = ci.getConsumerConfiguration();
        }
        String fnlStream = stream;
        String fnlConsumerName = consumerName;
        String fnlInboxDeliver = inboxDeliver;
        AutoStatusManager asm = isPullMode ? new PullAutoStatusManager() : new PushAutoStatusManager(this.conn, so, serverCc, qgroup != null, dispatcher == null);
        NatsSubscriptionFactory factory = (sid, lSubject, lQgroup, lConn, lDispatcher) -> NatsJetStreamSubscription.getInstance(sid, lSubject, lQgroup, lConn, lDispatcher, asm, this, isPullMode, fnlStream, fnlConsumerName, fnlInboxDeliver);
        if (dispatcher == null) {
            sub = (NatsJetStreamSubscription)this.conn.createSubscription(inboxDeliver, qgroup, null, factory);
        } else {
            MessageHandler handler = autoAck && serverCc.getAckPolicy() != AckPolicy.None ? msg -> {
                if (asm.manage(msg)) {
                    return;
                }
                userHandler.onMessage(msg);
                if (msg.lastAck() == null || msg.lastAck() == AckType.AckProgress) {
                    msg.ack();
                }
            } : msg -> {
                if (asm.manage(msg)) {
                    return;
                }
                userHandler.onMessage(msg);
            };
            sub = (NatsJetStreamSubscription)dispatcher.subscribeImplJetStream(inboxDeliver, qgroup, handler, factory);
        }
        asm.setSub(sub);
        return sub;
    }

    @Override
    public JetStreamSubscription subscribe(String subject) throws IOException, JetStreamApiException {
        Validator.validateSubject(subject, true);
        return this.createSubscription(subject, null, null, null, false, null, null);
    }

    @Override
    public JetStreamSubscription subscribe(String subject, PushSubscribeOptions options) throws IOException, JetStreamApiException {
        Validator.validateSubject(subject, true);
        return this.createSubscription(subject, null, null, null, false, options, null);
    }

    @Override
    public JetStreamSubscription subscribe(String subject, String queue, PushSubscribeOptions options) throws IOException, JetStreamApiException {
        Validator.validateSubject(subject, true);
        queue = Validator.emptyAsNull(Validator.validateQueueName(queue, false));
        return this.createSubscription(subject, queue, null, null, false, options, null);
    }

    @Override
    public JetStreamSubscription subscribe(String subject, Dispatcher dispatcher, MessageHandler handler, boolean autoAck) throws IOException, JetStreamApiException {
        Validator.validateSubject(subject, true);
        Validator.validateNotNull(dispatcher, "Dispatcher");
        Validator.validateNotNull(handler, "Handler");
        return this.createSubscription(subject, null, (NatsDispatcher)dispatcher, handler, autoAck, null, null);
    }

    @Override
    public JetStreamSubscription subscribe(String subject, Dispatcher dispatcher, MessageHandler handler, boolean autoAck, PushSubscribeOptions options) throws IOException, JetStreamApiException {
        Validator.validateSubject(subject, true);
        Validator.validateNotNull(dispatcher, "Dispatcher");
        Validator.validateNotNull(handler, "Handler");
        return this.createSubscription(subject, null, (NatsDispatcher)dispatcher, handler, autoAck, options, null);
    }

    @Override
    public JetStreamSubscription subscribe(String subject, String queue, Dispatcher dispatcher, MessageHandler handler, boolean autoAck, PushSubscribeOptions options) throws IOException, JetStreamApiException {
        Validator.validateSubject(subject, true);
        queue = Validator.emptyAsNull(Validator.validateQueueName(queue, false));
        Validator.validateNotNull(dispatcher, "Dispatcher");
        Validator.validateNotNull(handler, "Handler");
        return this.createSubscription(subject, queue, (NatsDispatcher)dispatcher, handler, autoAck, options, null);
    }

    @Override
    public JetStreamSubscription subscribe(String subject, PullSubscribeOptions options) throws IOException, JetStreamApiException {
        Validator.validateSubject(subject, true);
        Validator.validateNotNull(options, "Options");
        return this.createSubscription(subject, null, null, null, false, null, options);
    }

    ConsumerInfo lookupConsumerInfo(String stream, String consumer) throws IOException, JetStreamApiException {
        try {
            return this.getConsumerInfo(stream, consumer);
        }
        catch (JetStreamApiException e) {
            if (e.getApiErrorCode() == 10014 || e.getErrorCode() == 404 && e.getErrorDescription().contains("consumer")) {
                return null;
            }
            throw e;
        }
    }

    protected String lookupStreamBySubject(String subject) throws IOException, JetStreamApiException {
        byte[] body = JsonUtils.simpleMessageBody("subject", subject);
        StreamNamesReader snr = new StreamNamesReader();
        Message resp = this.makeRequestResponseRequired("STREAM.NAMES", body, this.jso.getRequestTimeout());
        snr.process(resp);
        return snr.getStrings().size() == 1 ? snr.getStrings().get(0) : null;
    }
}

