/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.support;

import io.nats.client.Message;
import io.nats.client.api.KeyValueOperation;
import io.nats.client.impl.Headers;

public abstract class NatsKeyValueUtil {
    public static final String KV_STREAM_PREFIX = "KV_";
    public static final int KV_STREAM_PREFIX_LEN = "KV_".length();
    public static final String KV_SUBJECT_PREFIX = "$KV.";
    public static final String KV_SUBJECT_SUFFIX = ".>";
    public static final String KV_OPERATION_HEADER_KEY = "KV-Operation";
    public static final Headers DELETE_HEADERS = new Headers().put("KV-Operation", KeyValueOperation.DELETE.getHeaderValue());
    public static final Headers PURGE_HEADERS = new Headers().put("KV-Operation", KeyValueOperation.PURGE.getHeaderValue()).put("Nats-Rollup", "sub");

    private NatsKeyValueUtil() {
    }

    public static String extractBucketName(String streamName) {
        return streamName.substring(KV_STREAM_PREFIX_LEN);
    }

    public static String toStreamName(String bucketName) {
        return KV_STREAM_PREFIX + bucketName;
    }

    public static String toStreamSubject(String bucketName) {
        return KV_SUBJECT_PREFIX + bucketName + KV_SUBJECT_SUFFIX;
    }

    public static String toKeyPrefix(String bucketName) {
        return KV_SUBJECT_PREFIX + bucketName + ".";
    }

    public static String getOperationHeader(Headers h) {
        return h == null ? null : h.getFirst(KV_OPERATION_HEADER_KEY);
    }

    public static KeyValueOperation getOperation(Headers h) {
        return KeyValueOperation.getOrDefault(NatsKeyValueUtil.getOperationHeader(h), KeyValueOperation.PUT);
    }

    public static class BucketAndKey {
        public final String bucket;
        public final String key;

        public BucketAndKey(Message m) {
            this(m.getSubject());
        }

        public BucketAndKey(String subject) {
            String[] split = subject.split("\\Q.\\E");
            this.bucket = split[1];
            this.key = split[2];
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BucketAndKey that = (BucketAndKey)o;
            if (!this.bucket.equals(that.bucket)) {
                return false;
            }
            return this.key.equals(that.key);
        }

        public int hashCode() {
            int result = this.bucket.hashCode();
            result = 31 * result + this.key.hashCode();
            return result;
        }
    }
}

