/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import java.time.Duration;

public class KeyValuePurgeOptions {
    public static long DEFAULT_THRESHOLD_MILLIS = Duration.ofMinutes(30L).toMillis();
    private final long deleteMarkersThresholdMillis;

    private KeyValuePurgeOptions(Builder b) {
        this.deleteMarkersThresholdMillis = b.deleteMarkersThresholdMillis;
    }

    public long getDeleteMarkersThresholdMillis() {
        return this.deleteMarkersThresholdMillis;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private long deleteMarkersThresholdMillis = DEFAULT_THRESHOLD_MILLIS;

        public Builder deleteMarkersThreshold(Duration deleteMarkersThreshold) {
            this.deleteMarkersThresholdMillis = deleteMarkersThreshold == null ? DEFAULT_THRESHOLD_MILLIS : deleteMarkersThreshold.toMillis();
            return this;
        }

        public Builder deleteMarkersThreshold(long deleteMarkersThresholdMillis) {
            this.deleteMarkersThresholdMillis = deleteMarkersThresholdMillis;
            return this;
        }

        public Builder deleteMarkersNoThreshold() {
            this.deleteMarkersThresholdMillis = -1L;
            return this;
        }

        public KeyValuePurgeOptions build() {
            if (this.deleteMarkersThresholdMillis < 0L) {
                this.deleteMarkersThresholdMillis = -1L;
            } else if (this.deleteMarkersThresholdMillis == 0L) {
                this.deleteMarkersThresholdMillis = DEFAULT_THRESHOLD_MILLIS;
            }
            return new KeyValuePurgeOptions(this);
        }
    }
}

