/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.Message;
import io.nats.client.impl.MessageManager;
import io.nats.client.impl.NatsConnection;
import io.nats.client.impl.NatsJetStream;
import io.nats.client.impl.NatsJetStreamSubscription;
import io.nats.client.impl.NatsMessage;
import io.nats.client.impl.PullStatusMessageManager;
import io.nats.client.support.JsonUtils;
import io.nats.client.support.Validator;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class NatsJetStreamPullSubscription
extends NatsJetStreamSubscription {
    private PullStatusMessageManager psmm;

    NatsJetStreamPullSubscription(String sid, String subject, NatsConnection connection, NatsJetStream js, String stream, String consumer, MessageManager[] managers) {
        super(sid, subject, null, connection, null, js, stream, consumer, managers);
        for (MessageManager mm : managers) {
            if (!(mm instanceof PullStatusMessageManager)) continue;
            this.psmm = (PullStatusMessageManager)mm;
            break;
        }
    }

    @Override
    boolean isPullMode() {
        return true;
    }

    @Override
    public void pull(int batchSize) {
        this._pull(batchSize, false, null);
    }

    @Override
    public void pullNoWait(int batchSize) {
        this._pull(batchSize, true, null);
    }

    @Override
    public void pullNoWait(int batchSize, Duration expiresIn) {
        this.durationGtZeroRequired(expiresIn, "NoWait");
        this._pull(batchSize, true, expiresIn);
    }

    @Override
    public void pullNoWait(int batchSize, long expiresInMillis) {
        this.durationGtZeroRequired(expiresInMillis, "NoWait");
        this._pull(batchSize, true, Duration.ofMillis(expiresInMillis));
    }

    @Override
    public void pullExpiresIn(int batchSize, Duration expiresIn) {
        this.durationGtZeroRequired(expiresIn, "Expires In");
        this._pull(batchSize, false, expiresIn);
    }

    @Override
    public void pullExpiresIn(int batchSize, long expiresInMillis) {
        this.durationGtZeroRequired(expiresInMillis, "Expires In");
        this._pull(batchSize, false, Duration.ofMillis(expiresInMillis));
    }

    private void _pull(int batchSize, boolean noWait, Duration expiresIn) {
        int batch = Validator.validatePullBatchSize(batchSize);
        String publishSubject = this.js.prependPrefix(String.format("CONSUMER.MSG.NEXT.%s.%s", this.stream, this.consumerName));
        this.connection.publish(publishSubject, this.getSubject(), this.getPullJson(batch, noWait, expiresIn));
        this.connection.lenientFlushBuffer();
    }

    byte[] getPullJson(int batch, boolean noWait, Duration expiresIn) {
        StringBuilder sb = JsonUtils.beginJson();
        JsonUtils.addField(sb, "batch", batch);
        JsonUtils.addFldWhenTrue(sb, "no_wait", noWait);
        JsonUtils.addFieldAsNanos(sb, "expires", expiresIn);
        return JsonUtils.endJson(sb).toString().getBytes(StandardCharsets.US_ASCII);
    }

    @Override
    public List<Message> fetch(int batchSize, long maxWaitMillis) {
        this.durationGtZeroRequired(maxWaitMillis, "Fetch");
        return this._fetch(batchSize, maxWaitMillis);
    }

    @Override
    public List<Message> fetch(int batchSize, Duration maxWait) {
        this.durationGtZeroRequired(maxWait, "Fetch");
        return this._fetch(batchSize, maxWait.toMillis());
    }

    private List<Message> _fetch(int batchSize, long maxWaitMillis) {
        List<Message> messages = this.drainAlreadyBuffered(batchSize);
        int batchLeft = batchSize - messages.size();
        if (batchLeft == 0) {
            return messages;
        }
        try {
            long start = System.currentTimeMillis();
            Duration expires = Duration.ofMillis(maxWaitMillis > 20L ? maxWaitMillis - 10L : maxWaitMillis);
            this._pull(batchLeft, false, expires);
            long timeLeft = maxWaitMillis;
            while (batchLeft > 0 && timeLeft > 0L) {
                NatsMessage msg = this.nextMessageInternal(Duration.ofMillis(timeLeft));
                if (msg == null) {
                    return messages;
                }
                if (!this.anyManaged(msg)) {
                    messages.add(msg);
                    --batchLeft;
                }
                timeLeft = maxWaitMillis - (System.currentTimeMillis() - start);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return messages;
    }

    private List<Message> drainAlreadyBuffered(int batchSize) {
        ArrayList<Message> messages = new ArrayList<Message>(batchSize);
        try {
            NatsMessage msg = this.nextMessageInternal(null);
            while (msg != null) {
                if (!this.anyManaged(msg)) {
                    messages.add(msg);
                    if (messages.size() == batchSize) {
                        return messages;
                    }
                }
                msg = this.nextMessageInternal(null);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return messages;
    }

    private void durationGtZeroRequired(Duration duration, String label) {
        if (duration == null || duration.toMillis() <= 0L) {
            throw new IllegalArgumentException(label + " wait duration must be supplied and greater than 0.");
        }
    }

    private void durationGtZeroRequired(long millis, String label) {
        if (millis <= 0L) {
            throw new IllegalArgumentException(label + " wait duration must be supplied and greater than 0.");
        }
    }

    @Override
    public Iterator<Message> iterate(int batchSize, Duration maxWait) {
        this.durationGtZeroRequired(maxWait, "Iterate");
        return this._iterate(batchSize, maxWait, null);
    }

    @Override
    public Iterator<Message> iterate(int batchSize, long maxWaitMillis) {
        this.durationGtZeroRequired(maxWaitMillis, "Iterate");
        return this._iterate(batchSize, null, maxWaitMillis);
    }

    private Iterator<Message> _iterate(final int batchSize, Duration maxWait, Long maxWaitMillis) {
        final List<Message> buffered = this.drainAlreadyBuffered(batchSize);
        int batchLeft = batchSize - buffered.size();
        if (batchLeft == 0) {
            return new Iterator<Message>(){

                @Override
                public boolean hasNext() {
                    return buffered.size() > 0;
                }

                @Override
                public Message next() {
                    return (Message)buffered.remove(0);
                }
            };
        }
        this._pull(batchLeft, false, maxWait == null ? Duration.ofMillis(maxWaitMillis) : maxWait);
        final long timeout = maxWaitMillis == null ? maxWait.toMillis() : maxWaitMillis.longValue();
        return new Iterator<Message>(){
            int received = 0;
            boolean done = false;
            Message msg = null;

            @Override
            public boolean hasNext() {
                try {
                    if (this.msg != null) {
                        return true;
                    }
                    if (this.done) {
                        return false;
                    }
                    if (buffered.size() == 0) {
                        this.msg = NatsJetStreamPullSubscription.this._nextUnmanaged(timeout);
                        if (this.msg == null) {
                            this.done = true;
                            return false;
                        }
                    } else {
                        this.msg = (Message)buffered.remove(0);
                    }
                    this.done = ++this.received == batchSize;
                    return true;
                }
                catch (InterruptedException e) {
                    this.msg = null;
                    this.done = true;
                    Thread.currentThread().interrupt();
                    return false;
                }
            }

            @Override
            public Message next() {
                Message next = this.msg;
                this.msg = null;
                return next;
            }
        };
    }
}

