/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.JetStreamStatusException;
import io.nats.client.Message;
import io.nats.client.impl.MessageManager;
import java.util.Arrays;
import java.util.List;

class PullStatusMessageManager
extends MessageManager {
    private static final List<Integer> PULL_KNOWN_STATUS_CODES = Arrays.asList(404, 408);
    private int lastStatusCode = -1;

    PullStatusMessageManager() {
    }

    @Override
    boolean manage(Message msg) {
        if (msg.isStatusMessage()) {
            this.lastStatusCode = msg.getStatus().getCode();
            if (!PULL_KNOWN_STATUS_CODES.contains(this.lastStatusCode)) {
                throw new JetStreamStatusException(this.sub, msg.getStatus());
            }
            return true;
        }
        this.lastStatusCode = -1;
        return false;
    }

    public int getLastStatusCode() {
        return this.lastStatusCode;
    }
}

