/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.Dispatcher;
import io.nats.client.JetStream;
import io.nats.client.JetStreamApiException;
import io.nats.client.JetStreamOptions;
import io.nats.client.JetStreamSubscription;
import io.nats.client.Message;
import io.nats.client.MessageHandler;
import io.nats.client.PublishOptions;
import io.nats.client.PullSubscribeOptions;
import io.nats.client.PushSubscribeOptions;
import io.nats.client.SubscribeOptions;
import io.nats.client.api.AckPolicy;
import io.nats.client.api.ConsumerConfiguration;
import io.nats.client.api.ConsumerInfo;
import io.nats.client.api.PublishAck;
import io.nats.client.api.StreamInfo;
import io.nats.client.impl.Headers;
import io.nats.client.impl.MessageManager;
import io.nats.client.impl.NatsConnection;
import io.nats.client.impl.NatsDispatcher;
import io.nats.client.impl.NatsJetStreamImplBase;
import io.nats.client.impl.NatsJetStreamPullSubscription;
import io.nats.client.impl.NatsJetStreamSubscription;
import io.nats.client.impl.NatsSubscriptionFactory;
import io.nats.client.impl.OrderedManager;
import io.nats.client.impl.PullStatusMessageManager;
import io.nats.client.impl.PushStatusMessageManager;
import io.nats.client.impl.StreamNamesReader;
import io.nats.client.support.JsonUtils;
import io.nats.client.support.NatsJetStreamClientError;
import io.nats.client.support.Validator;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class NatsJetStream
extends NatsJetStreamImplBase
implements JetStream {
    private static final PushSubscribeOptions DEFAULT_PUSH_OPTS = PushSubscribeOptions.builder().build();
    static PushStatusMessageManagerFactory PUSH_STATUS_MANAGER_FACTORY = PushStatusMessageManager::new;

    public NatsJetStream(NatsConnection connection, JetStreamOptions jsOptions) throws IOException {
        super(connection, jsOptions);
    }

    @Override
    public PublishAck publish(String subject, byte[] body) throws IOException, JetStreamApiException {
        return this.publishSyncInternal(subject, null, body, false, null);
    }

    @Override
    public PublishAck publish(String subject, byte[] body, PublishOptions options) throws IOException, JetStreamApiException {
        return this.publishSyncInternal(subject, null, body, options);
    }

    @Override
    public PublishAck publish(Message message) throws IOException, JetStreamApiException {
        Validator.validateNotNull(message, "Message");
        return this.publishSyncInternal(message.getSubject(), message.getHeaders(), message.getData(), message.isUtf8mode(), null);
    }

    @Override
    public PublishAck publish(Message message, PublishOptions options) throws IOException, JetStreamApiException {
        Validator.validateNotNull(message, "Message");
        return this.publishSyncInternal(message.getSubject(), message.getHeaders(), message.getData(), message.isUtf8mode(), options);
    }

    @Override
    public CompletableFuture<PublishAck> publishAsync(String subject, byte[] body) {
        return this.publishAsyncInternal(subject, null, body, null, null);
    }

    @Override
    public CompletableFuture<PublishAck> publishAsync(String subject, byte[] body, PublishOptions options) {
        return this.publishAsyncInternal(subject, null, body, options, null);
    }

    @Override
    public CompletableFuture<PublishAck> publishAsync(Message message) {
        Validator.validateNotNull(message, "Message");
        return this.publishAsyncInternal(message.getSubject(), message.getHeaders(), message.getData(), message.isUtf8mode(), null, null);
    }

    @Override
    public CompletableFuture<PublishAck> publishAsync(Message message, PublishOptions options) {
        Validator.validateNotNull(message, "Message");
        return this.publishAsyncInternal(message.getSubject(), message.getHeaders(), message.getData(), message.isUtf8mode(), options, null);
    }

    private PublishAck publishSyncInternal(String subject, Headers headers, byte[] data, PublishOptions options) throws IOException, JetStreamApiException {
        return this.publishSyncInternal(subject, headers, data, false, options);
    }

    @Deprecated
    private PublishAck publishSyncInternal(String subject, Headers headers, byte[] data, boolean utf8mode, PublishOptions options) throws IOException, JetStreamApiException {
        Headers merged = this.mergePublishOptions(headers, options);
        if (this.jso.isPublishNoAck()) {
            this.conn.publishInternal(subject, null, merged, data, utf8mode);
            return null;
        }
        Duration timeout = options == null ? this.jso.getRequestTimeout() : options.getStreamTimeout();
        Message resp = this.makeInternalRequestResponseRequired(subject, merged, data, utf8mode, timeout, false);
        return this.processPublishResponse(resp, options);
    }

    private CompletableFuture<PublishAck> publishAsyncInternal(String subject, Headers headers, byte[] data, PublishOptions options, Duration knownTimeout) {
        return this.publishAsyncInternal(subject, headers, data, false, options, knownTimeout);
    }

    @Deprecated
    private CompletableFuture<PublishAck> publishAsyncInternal(String subject, Headers headers, byte[] data, boolean utf8mode, PublishOptions options, Duration knownTimeout) {
        Headers merged = this.mergePublishOptions(headers, options);
        if (this.jso.isPublishNoAck()) {
            this.conn.publishInternal(subject, null, merged, data, utf8mode);
            return null;
        }
        CompletableFuture<Message> future = this.conn.requestFutureInternal(subject, merged, data, utf8mode, knownTimeout, false);
        return future.thenCompose(resp -> {
            try {
                this.responseRequired((Message)resp);
                return CompletableFuture.completedFuture(this.processPublishResponse((Message)resp, options));
            }
            catch (JetStreamApiException | IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private PublishAck processPublishResponse(Message resp, PublishOptions options) throws IOException, JetStreamApiException {
        String pubStream;
        if (resp.isStatusMessage()) {
            throw new IOException("Error Publishing: " + resp.getStatus().getCode() + " " + resp.getStatus().getMessage());
        }
        PublishAck ack = new PublishAck(resp);
        String ackStream = ack.getStream();
        String string = pubStream = options == null ? null : options.getStream();
        if (pubStream != null && !pubStream.equals(ackStream)) {
            throw new IOException("Expected ack from stream " + pubStream + ", received from: " + ackStream);
        }
        return ack;
    }

    private Headers mergePublishOptions(Headers headers, PublishOptions opts) {
        Headers merged;
        Headers headers2 = merged = headers == null ? null : new Headers(headers);
        if (opts != null) {
            merged = this.mergeNum(merged, "Nats-Expected-Last-Sequence", opts.getExpectedLastSequence());
            merged = this.mergeNum(merged, "Nats-Expected-Last-Subject-Sequence", opts.getExpectedLastSubjectSequence());
            merged = this.mergeString(merged, "Nats-Expected-Last-Msg-Id", opts.getExpectedLastMsgId());
            merged = this.mergeString(merged, "Nats-Expected-Stream", opts.getExpectedStream());
            merged = this.mergeString(merged, "Nats-Msg-Id", opts.getMessageId());
        }
        return merged;
    }

    private Headers mergeNum(Headers h, String key, long value) {
        return value > -1L ? this._mergeNum(h, key, Long.toString(value)) : h;
    }

    private Headers mergeString(Headers h, String key, String value) {
        return Validator.nullOrEmpty(value) ? h : this._mergeNum(h, key, value);
    }

    private Headers _mergeNum(Headers h, String key, String value) {
        if (h == null) {
            h = new Headers();
        }
        return h.add(key, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    JetStreamSubscription createSubscription(String subject, String queueName, NatsDispatcher dispatcher, MessageHandler userHandler, boolean isAutoAck, PushSubscribeOptions pushSubscribeOptions, PullSubscribeOptions pullSubscribeOptions) throws IOException, JetStreamApiException {
        NatsJetStreamSubscription sub;
        String settledConsumerName;
        ConsumerConfiguration settledServerCC;
        String fnlInboxDeliver;
        String fnlStream;
        String qgroup;
        ConsumerConfiguration userCC;
        String stream;
        SubscribeOptions so;
        boolean isPullMode;
        boolean bl = isPullMode = pullSubscribeOptions != null;
        if (isPullMode) {
            so = pullSubscribeOptions;
            stream = pullSubscribeOptions.getStream();
            userCC = so.getConsumerConfiguration();
            qgroup = null;
            Validator.validateNotSupplied(userCC.getDeliverGroup(), NatsJetStreamClientError.JsSubPullCantHaveDeliverGroup);
            Validator.validateNotSupplied(userCC.getDeliverSubject(), NatsJetStreamClientError.JsSubPullCantHaveDeliverSubject);
        } else {
            so = pushSubscribeOptions == null ? DEFAULT_PUSH_OPTS : pushSubscribeOptions;
            stream = so.getStream();
            userCC = so.getConsumerConfiguration();
            if (userCC.maxPullWaitingWasSet()) {
                throw NatsJetStreamClientError.JsSubPushCantHaveMaxPullWaiting.instance();
            }
            if (userCC.maxBatchWasSet()) {
                throw NatsJetStreamClientError.JsSubPushCantHaveMaxBatch.instance();
            }
            qgroup = Validator.validateMustMatchIfBothSupplied(userCC.getDeliverGroup(), queueName, NatsJetStreamClientError.JsSubQueueDeliverGroupMismatch);
            if (so.isOrdered() && qgroup != null) {
                throw NatsJetStreamClientError.JsSubOrderedNotAllowOnQueues.instance();
            }
        }
        if (userCC.isFlowControl() || userCC.getIdleHeartbeat() != null && userCC.getIdleHeartbeat().toMillis() > 0L) {
            if (isPullMode) {
                throw NatsJetStreamClientError.JsSubFcHbNotValidPull.instance();
            }
            if (qgroup != null) {
                throw NatsJetStreamClientError.JsSubFcHbHbNotValidQueue.instance();
            }
        }
        if (stream == null) {
            fnlStream = this.lookupStreamBySubject(subject);
            if (fnlStream == null) {
                throw NatsJetStreamClientError.JsSubNoMatchingStreamForSubject.instance();
            }
        } else {
            fnlStream = stream;
        }
        ConsumerConfiguration serverCC = null;
        String consumerName = userCC.getDurable();
        String inboxDeliver = userCC.getDeliverSubject();
        if (consumerName != null) {
            ConsumerInfo serverInfo = this.lookupConsumerInfo(fnlStream, consumerName);
            if (serverInfo != null) {
                ConsumerConfigurationComparer userCCC = new ConsumerConfigurationComparer(userCC);
                serverCC = serverInfo.getConsumerConfiguration();
                List<String> changes = userCCC.getChanges(serverCC);
                if (changes.size() > 0) {
                    throw NatsJetStreamClientError.JsSubExistingConsumerCannotBeModified.instance("Changed fields: " + changes.toString());
                }
                if (isPullMode) {
                    if (!Validator.nullOrEmpty(serverCC.getDeliverSubject())) {
                        throw NatsJetStreamClientError.JsSubConsumerAlreadyConfiguredAsPush.instance();
                    }
                } else if (Validator.nullOrEmpty(serverCC.getDeliverSubject())) {
                    throw NatsJetStreamClientError.JsSubConsumerAlreadyConfiguredAsPull.instance();
                }
                if (serverCC.getDeliverGroup() == null) {
                    if (qgroup != null) throw NatsJetStreamClientError.JsSubExistingConsumerNotQueue.instance();
                    if (serverInfo.isPushBound()) {
                        throw NatsJetStreamClientError.JsSubConsumerAlreadyBound.instance();
                    }
                } else {
                    if (qgroup == null) {
                        throw NatsJetStreamClientError.JsSubExistingConsumerIsQueue.instance();
                    }
                    if (!serverCC.getDeliverGroup().equals(qgroup)) {
                        throw NatsJetStreamClientError.JsSubExistingQueueDoesNotMatchRequestedQueue.instance();
                    }
                }
                if (Validator.nullOrEmpty(subject)) {
                    subject = userCC.getFilterSubject();
                } else if (!this.isFilterMatch(subject, serverCC.getFilterSubject(), fnlStream)) {
                    throw NatsJetStreamClientError.JsSubSubjectDoesNotMatchFilter.instance();
                }
                inboxDeliver = serverCC.getDeliverSubject();
            } else if (so.isBind()) {
                throw NatsJetStreamClientError.JsSubConsumerNotFoundRequiredInBind.instance();
            }
        }
        String string = fnlInboxDeliver = inboxDeliver == null ? this.conn.createInbox() : inboxDeliver;
        if (serverCC == null) {
            ConsumerConfiguration.Builder ccBuilder = ConsumerConfiguration.builder(userCC);
            if (!isPullMode) {
                ccBuilder.deliverSubject(fnlInboxDeliver);
            }
            if (userCC.getFilterSubject() == null) {
                ccBuilder.filterSubject(subject);
            }
            ccBuilder.deliverGroup(qgroup);
            settledServerCC = ccBuilder.build();
            settledConsumerName = null;
        } else {
            settledServerCC = serverCC;
            settledConsumerName = consumerName;
        }
        if (isPullMode) {
            MessageManager[] managers = new MessageManager[]{new PullStatusMessageManager()};
            NatsSubscriptionFactory factory = (sid, lSubject, lQgroup, lConn, lDispatcher) -> new NatsJetStreamPullSubscription(sid, lSubject, lConn, this, fnlStream, settledConsumerName, managers);
            sub = (NatsJetStreamSubscription)this.conn.createSubscription(fnlInboxDeliver, qgroup, null, factory);
        } else {
            PushStatusMessageManager statusManager = PUSH_STATUS_MANAGER_FACTORY.createPushStatusMessageManager(this.conn, so, settledServerCC, qgroup != null, dispatcher == null);
            MessageManager[] managers = so.isOrdered() ? new MessageManager[]{new SidCheckManager(), statusManager, new OrderedManager(this, dispatcher, fnlStream, settledServerCC)} : new MessageManager[]{statusManager};
            NatsSubscriptionFactory factory = (sid, lSubject, lQgroup, lConn, lDispatcher) -> new NatsJetStreamSubscription(sid, lSubject, lQgroup, lConn, lDispatcher, this, fnlStream, settledConsumerName, managers);
            if (dispatcher == null) {
                sub = (NatsJetStreamSubscription)this.conn.createSubscription(fnlInboxDeliver, qgroup, null, factory);
            } else {
                AsyncMessageHandler handler = new AsyncMessageHandler(userHandler, isAutoAck, settledServerCC, managers);
                sub = (NatsJetStreamSubscription)dispatcher.subscribeImplJetStream(fnlInboxDeliver, qgroup, handler, factory);
            }
        }
        if (settledConsumerName != null) return sub;
        try {
            ConsumerInfo ci = this._createConsumer(fnlStream, settledServerCC);
            sub.setConsumerName(ci.getName());
            return sub;
        }
        catch (JetStreamApiException | IOException e) {
            if (dispatcher == null) {
                sub.unsubscribe();
                throw e;
            } else {
                dispatcher.unsubscribe(sub);
            }
            throw e;
        }
    }

    private boolean isFilterMatch(String subscribeSubject, String filterSubject, String stream) throws IOException, JetStreamApiException {
        if (subscribeSubject.equals(filterSubject)) {
            return true;
        }
        if (Validator.nullOrEmpty(filterSubject) || filterSubject.equals(">")) {
            String streamSubject = this.lookupStreamSubject(stream);
            return subscribeSubject.equals(streamSubject);
        }
        return false;
    }

    private String lookupStreamSubject(String stream) throws IOException, JetStreamApiException {
        StreamInfo si = this._getStreamInfo(stream, null);
        List<String> streamSubjects = si.getConfiguration().getSubjects();
        return streamSubjects.size() == 1 ? streamSubjects.get(0) : null;
    }

    @Override
    public JetStreamSubscription subscribe(String subject) throws IOException, JetStreamApiException {
        Validator.validateSubject(subject, true);
        return this.createSubscription(subject, null, null, null, false, null, null);
    }

    @Override
    public JetStreamSubscription subscribe(String subject, PushSubscribeOptions options) throws IOException, JetStreamApiException {
        Validator.validateSubject(subject, this.isSubjectRequired(options));
        return this.createSubscription(subject, null, null, null, false, options, null);
    }

    @Override
    public JetStreamSubscription subscribe(String subject, String queue, PushSubscribeOptions options) throws IOException, JetStreamApiException {
        Validator.validateSubject(subject, this.isSubjectRequired(options));
        queue = Validator.emptyAsNull(Validator.validateQueueName(queue, false));
        return this.createSubscription(subject, queue, null, null, false, options, null);
    }

    @Override
    public JetStreamSubscription subscribe(String subject, Dispatcher dispatcher, MessageHandler handler, boolean autoAck) throws IOException, JetStreamApiException {
        Validator.validateSubject(subject, true);
        Validator.validateNotNull(dispatcher, "Dispatcher");
        Validator.validateNotNull(handler, "Handler");
        return this.createSubscription(subject, null, (NatsDispatcher)dispatcher, handler, autoAck, null, null);
    }

    @Override
    public JetStreamSubscription subscribe(String subject, Dispatcher dispatcher, MessageHandler handler, boolean autoAck, PushSubscribeOptions options) throws IOException, JetStreamApiException {
        Validator.validateSubject(subject, this.isSubjectRequired(options));
        Validator.validateNotNull(dispatcher, "Dispatcher");
        Validator.validateNotNull(handler, "Handler");
        return this.createSubscription(subject, null, (NatsDispatcher)dispatcher, handler, autoAck, options, null);
    }

    @Override
    public JetStreamSubscription subscribe(String subject, String queue, Dispatcher dispatcher, MessageHandler handler, boolean autoAck, PushSubscribeOptions options) throws IOException, JetStreamApiException {
        Validator.validateSubject(subject, this.isSubjectRequired(options));
        queue = Validator.emptyAsNull(Validator.validateQueueName(queue, false));
        Validator.validateNotNull(dispatcher, "Dispatcher");
        Validator.validateNotNull(handler, "Handler");
        return this.createSubscription(subject, queue, (NatsDispatcher)dispatcher, handler, autoAck, options, null);
    }

    @Override
    public JetStreamSubscription subscribe(String subject, PullSubscribeOptions options) throws IOException, JetStreamApiException {
        Validator.validateNotNull(options, "Pull Subscribe Options");
        Validator.validateSubject(subject, this.isSubjectRequired(options));
        return this.createSubscription(subject, null, null, null, false, null, options);
    }

    private boolean isSubjectRequired(SubscribeOptions options) {
        return options == null || !options.isBind();
    }

    ConsumerInfo lookupConsumerInfo(String stream, String consumer) throws IOException, JetStreamApiException {
        try {
            return this._getConsumerInfo(stream, consumer);
        }
        catch (JetStreamApiException e) {
            if (e.getApiErrorCode() == 10014 || e.getErrorCode() == 404 && e.getErrorDescription().contains("consumer")) {
                return null;
            }
            throw e;
        }
    }

    protected String lookupStreamBySubject(String subject) throws IOException, JetStreamApiException {
        byte[] body = JsonUtils.simpleMessageBody("subject", subject);
        StreamNamesReader snr = new StreamNamesReader();
        Message resp = this.makeRequestResponseRequired("STREAM.NAMES", body, this.jso.getRequestTimeout());
        snr.process(resp);
        return snr.getStrings().size() == 1 ? snr.getStrings().get(0) : null;
    }

    static class AsyncMessageHandler
    implements MessageHandler {
        List<MessageManager> managers;
        List<MessageHandler> handlers = new ArrayList<MessageHandler>();

        public AsyncMessageHandler(MessageHandler userHandler, boolean isAutoAck, ConsumerConfiguration settledServerCC, MessageManager ... managers) {
            this.handlers.add(userHandler);
            if (isAutoAck && settledServerCC.getAckPolicy() != AckPolicy.None) {
                this.handlers.add(Message::ack);
            }
            this.managers = new ArrayList<MessageManager>();
            for (MessageManager mm : managers) {
                if (mm == null) continue;
                this.managers.add(mm);
            }
        }

        @Override
        public void onMessage(Message msg) throws InterruptedException {
            for (MessageManager mm : this.managers) {
                if (!mm.manage(msg)) continue;
                return;
            }
            for (MessageHandler mh : this.handlers) {
                mh.onMessage(msg);
            }
        }
    }

    static class ConsumerConfigurationComparer
    extends ConsumerConfiguration {
        public ConsumerConfigurationComparer(ConsumerConfiguration cc) {
            super(cc);
        }

        public List<String> getChanges(ConsumerConfiguration serverCc) {
            ConsumerConfigurationComparer serverCcc = new ConsumerConfigurationComparer(serverCc);
            ArrayList<String> changes = new ArrayList<String>();
            this.record(this.deliverPolicy != null && this.deliverPolicy != serverCcc.getDeliverPolicy(), "deliverPolicy", changes);
            this.record(this.ackPolicy != null && this.ackPolicy != serverCcc.getAckPolicy(), "ackPolicy", changes);
            this.record(this.replayPolicy != null && this.replayPolicy != serverCcc.getReplayPolicy(), "replayPolicy", changes);
            this.record(this.flowControl != null && this.flowControl.booleanValue() != serverCcc.isFlowControl(), "flowControl", changes);
            this.record(this.headersOnly != null && this.headersOnly.booleanValue() != serverCcc.isHeadersOnly(), "headersOnly", changes);
            this.record(this.startSeq != null && !this.startSeq.equals(serverCcc.getStartSequence()), "startSequence", changes);
            this.record(this.rateLimit != null && !this.rateLimit.equals(serverCcc.getStartSequence()), "rateLimit", changes);
            this.record(ConsumerConfiguration.LongChangeHelper.MAX_DELIVER.wouldBeChange(this.maxDeliver, serverCcc.maxDeliver), "maxDeliver", changes);
            this.record(this.maxAckPending != null && !this.maxAckPending.equals(serverCcc.getMaxAckPending()), "maxAckPending", changes);
            this.record(this.maxPullWaiting != null && !this.maxPullWaiting.equals(serverCcc.getMaxPullWaiting()), "maxPullWaiting", changes);
            this.record(this.maxBatch != null && !this.maxBatch.equals(serverCcc.getMaxBatch()), "maxBatch", changes);
            this.record(this.ackWait != null && !this.ackWait.equals(ConsumerConfigurationComparer.getOrUnset(serverCcc.ackWait)), "ackWait", changes);
            this.record(this.idleHeartbeat != null && !this.idleHeartbeat.equals(ConsumerConfigurationComparer.getOrUnset(serverCcc.idleHeartbeat)), "idleHeartbeat", changes);
            this.record(this.maxExpires != null && !this.maxExpires.equals(ConsumerConfigurationComparer.getOrUnset(serverCcc.maxExpires)), "maxExpires", changes);
            this.record(this.inactiveThreshold != null && !this.inactiveThreshold.equals(ConsumerConfigurationComparer.getOrUnset(serverCcc.inactiveThreshold)), "inactiveThreshold", changes);
            this.record(this.startTime != null && !this.startTime.equals(serverCcc.startTime), "startTime", changes);
            this.record(this.filterSubject != null && !this.filterSubject.equals(serverCcc.filterSubject), "filterSubject", changes);
            this.record(this.description != null && !this.description.equals(serverCcc.description), "description", changes);
            this.record(this.sampleFrequency != null && !this.sampleFrequency.equals(serverCcc.sampleFrequency), "sampleFrequency", changes);
            this.record(this.deliverSubject != null && !this.deliverSubject.equals(serverCcc.deliverSubject), "deliverSubject", changes);
            this.record(this.deliverGroup != null && !this.deliverGroup.equals(serverCcc.deliverGroup), "deliverGroup", changes);
            this.record(!this.backoff.equals(serverCcc.backoff), "backoff", changes);
            return changes;
        }

        private void record(boolean isChange, String field, List<String> changes) {
            if (isChange) {
                changes.add(field);
            }
        }
    }

    static interface PushStatusMessageManagerFactory {
        public PushStatusMessageManager createPushStatusMessageManager(NatsConnection var1, SubscribeOptions var2, ConsumerConfiguration var3, boolean var4, boolean var5);
    }

    static class SidCheckManager
    extends MessageManager {
        SidCheckManager() {
        }

        @Override
        boolean manage(Message msg) {
            return !this.sub.getSID().equals(msg.getSID());
        }
    }
}

