/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.api.Replica;
import io.nats.client.support.ApiConstants;
import io.nats.client.support.JsonUtils;
import java.util.List;

public class ClusterInfo {
    private final String name;
    private final String leader;
    private final List<Replica> replicas;

    static ClusterInfo optionalInstance(String fullJson) {
        String objJson = JsonUtils.getJsonObject("cluster", fullJson, null);
        return objJson == null ? null : new ClusterInfo(objJson);
    }

    ClusterInfo(String json) {
        this.name = JsonUtils.readString(json, ApiConstants.NAME_RE);
        this.leader = JsonUtils.readString(json, ApiConstants.LEADER_RE);
        this.replicas = Replica.optionalListOf(json);
    }

    public String getName() {
        return this.name;
    }

    public String getLeader() {
        return this.leader;
    }

    public List<Replica> getReplicas() {
        return this.replicas;
    }

    public String toString() {
        return "ClusterInfo{name='" + this.name + '\'' + ", leader='" + this.leader + '\'' + ", replicas=" + this.replicas + '}';
    }
}

