/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.JetStreamStatusException;
import io.nats.client.Message;
import io.nats.client.impl.MessageManager;
import java.util.Arrays;
import java.util.List;

class PullStatusMessageManager
extends MessageManager {
    private static final List<Integer> PULL_KNOWN_STATUS_CODES = Arrays.asList(404, 408, 409);

    PullStatusMessageManager() {
    }

    @Override
    boolean manage(Message msg) {
        if (msg.isStatusMessage()) {
            if (!PULL_KNOWN_STATUS_CODES.contains(msg.getStatus().getCode())) {
                throw new JetStreamStatusException(this.sub, msg.getStatus());
            }
            return true;
        }
        return false;
    }
}

