/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.support;

import io.nats.client.api.SequencePair;
import io.nats.client.support.DateTimeUtils;
import io.nats.client.support.Encoding;
import io.nats.client.support.JsonSerializable;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class JsonUtils {
    public static final String EMPTY_JSON = "{}";
    private static final String STRING_RE = "\"(.+?)\"";
    private static final String BOOLEAN_RE = "(true|false)";
    private static final String INTEGER_RE = "(-?\\d+)";
    private static final String STRING_ARRAY_RE = "\\[\\s*(\".+?\")\\s*\\]";
    private static final String NUMBER_ARRAY_RE = "\\[\\s*(.+?)\\s*\\]";
    private static final String BEFORE_FIELD_RE = "\"";
    private static final String AFTER_FIELD_RE = "\"\\s*:\\s*";
    private static final String Q = "\"";
    private static final String QCOLONQ = "\":\"";
    private static final String QCOLON = "\":";
    private static final String QCOMMA = "\",";
    private static final String COMMA = ",";
    public static final String OPENQ = "{\"";
    public static final String CLOSE = "}";
    private static final String INDENT = "                                ";

    private JsonUtils() {
    }

    public static Pattern string_pattern(String field) {
        return JsonUtils.buildPattern(field, STRING_RE);
    }

    @Deprecated
    public static Pattern number_pattern(String field) {
        return JsonUtils.integer_pattern(field);
    }

    public static Pattern integer_pattern(String field) {
        return JsonUtils.buildPattern(field, INTEGER_RE);
    }

    public static Pattern boolean_pattern(String field) {
        return JsonUtils.buildPattern(field, BOOLEAN_RE);
    }

    public static Pattern string_array_pattern(String field) {
        return JsonUtils.buildPattern(field, STRING_ARRAY_RE);
    }

    public static Pattern number_array_pattern(String field) {
        return JsonUtils.buildPattern(field, NUMBER_ARRAY_RE);
    }

    public static Pattern buildPattern(String fieldName, FieldType type) {
        return JsonUtils.buildPattern(fieldName, type.re);
    }

    public static Pattern buildPattern(String fieldName, String typeRE) {
        return Pattern.compile("\"" + fieldName + AFTER_FIELD_RE + typeRE, 2);
    }

    public static String getJsonObject(String objectName, String json) {
        return JsonUtils.getJsonObject(objectName, json, EMPTY_JSON);
    }

    public static String getJsonObject(String objectName, String json, String dflt) {
        int[] indexes = JsonUtils.getBracketIndexes(objectName, json, '{', '}', 0);
        return indexes == null ? dflt : json.substring(indexes[0], indexes[1] + 1);
    }

    public static List<String> getObjectList(String objectName, String json) {
        ArrayList<String> items = new ArrayList<String>();
        int[] indexes = JsonUtils.getBracketIndexes(objectName, json, '[', ']', -1);
        if (indexes != null) {
            StringBuilder item = new StringBuilder();
            int depth = 0;
            for (int x = indexes[0] + 1; x < indexes[1]; ++x) {
                char c = json.charAt(x);
                if (c == '{') {
                    item.append(c);
                    ++depth;
                    continue;
                }
                if (c == '}') {
                    item.append(c);
                    if (--depth != 0) continue;
                    items.add(item.toString());
                    item.setLength(0);
                    continue;
                }
                if (depth <= 0) continue;
                item.append(c);
            }
        }
        return items;
    }

    private static int[] getBracketIndexes(String objectName, String json, char start, char end, int fromIndex) {
        int[] result = new int[]{-1, -1};
        int objStart = json.indexOf("\"" + objectName + "\"", fromIndex);
        if (objStart != -1) {
            char c;
            int x;
            int startIx;
            if (fromIndex != -1) {
                int colonMark = json.indexOf(58, objStart) + 1;
                startIx = json.indexOf(start, colonMark);
                for (x = colonMark; x < startIx; ++x) {
                    c = json.charAt(x);
                    if (Character.isWhitespace(c)) continue;
                    return JsonUtils.getBracketIndexes(objectName, json, start, end, colonMark);
                }
            } else {
                startIx = json.indexOf(start, objStart);
            }
            int depth = 1;
            for (x = startIx + 1; x < json.length(); ++x) {
                c = json.charAt(x);
                if (c == start) {
                    ++depth;
                    continue;
                }
                if (c != end || --depth != 0) continue;
                result[0] = startIx;
                result[1] = x;
                return result;
            }
        }
        return null;
    }

    public static List<String> getStringList(String objectName, String json) {
        String flat = json.replaceAll("\r", "").replaceAll("\n", "");
        ArrayList<String> list = new ArrayList<String>();
        Matcher m = JsonUtils.string_array_pattern(objectName).matcher(flat);
        if (m.find()) {
            String[] raw;
            String arrayString = m.group(1);
            for (String s : raw = arrayString.split(COMMA)) {
                String cleaned = s.trim().replace("\"", "");
                if (cleaned.length() <= 0) continue;
                list.add(Encoding.jsonDecode(cleaned));
            }
        }
        return list;
    }

    public static List<Long> getLongList(String objectName, String json) {
        String flat = json.replaceAll("\r", "").replaceAll("\n", "");
        ArrayList<Long> list = new ArrayList<Long>();
        Matcher m = JsonUtils.number_array_pattern(objectName).matcher(flat);
        if (m.find()) {
            String[] raw;
            String arrayString = m.group(1);
            for (String s : raw = arrayString.split(COMMA)) {
                list.add(JsonUtils.safeParseLong(s.trim()));
            }
        }
        return list;
    }

    public static List<Duration> getDurationList(String objectName, String json) {
        List<Long> longs = JsonUtils.getLongList(objectName, json);
        ArrayList<Duration> list = new ArrayList<Duration>(longs.size());
        for (Long l : longs) {
            list.add(Duration.ofNanos(l));
        }
        return list;
    }

    public static byte[] simpleMessageBody(String name, Number value) {
        return (OPENQ + name + QCOLON + value + CLOSE).getBytes();
    }

    public static byte[] simpleMessageBody(String name, String value) {
        return (OPENQ + name + QCOLONQ + value + "\"" + CLOSE).getBytes();
    }

    public static StringBuilder beginJson() {
        return new StringBuilder("{");
    }

    public static StringBuilder beginJsonPrefixed(String prefix) {
        return prefix == null ? JsonUtils.beginJson() : new StringBuilder(prefix).append(" ").append('{');
    }

    public static StringBuilder endJson(StringBuilder sb) {
        sb.setLength(sb.length() - 1);
        sb.append(CLOSE);
        return sb;
    }

    public static StringBuilder beginFormattedJson() {
        return new StringBuilder("{\n    ");
    }

    public static String endFormattedJson(StringBuilder sb) {
        sb.setLength(sb.length() - 1);
        sb.append("\n}");
        return sb.toString().replaceAll(COMMA, ",\n    ");
    }

    public static void addField(StringBuilder sb, String fname, String value) {
        if (value != null && value.length() > 0) {
            sb.append("\"");
            Encoding.jsonEncode(sb, fname);
            sb.append(QCOLONQ);
            Encoding.jsonEncode(sb, value);
            sb.append(QCOMMA);
        }
    }

    public static void addFieldEvenEmpty(StringBuilder sb, String fname, String value) {
        if (value == null) {
            value = "";
        }
        sb.append("\"");
        Encoding.jsonEncode(sb, fname);
        sb.append(QCOLONQ);
        Encoding.jsonEncode(sb, value);
        sb.append(QCOMMA);
    }

    public static void addField(StringBuilder sb, String fname, Boolean value) {
        if (value != null) {
            sb.append("\"");
            Encoding.jsonEncode(sb, fname);
            sb.append(QCOLON).append(value != false ? "true" : "false").append(COMMA);
        }
    }

    public static void addFldWhenTrue(StringBuilder sb, String fname, Boolean value) {
        if (value != null && value.booleanValue()) {
            JsonUtils.addField(sb, fname, true);
        }
    }

    public static void addField(StringBuilder sb, String fname, Integer value) {
        if (value != null && value >= 0) {
            sb.append("\"");
            Encoding.jsonEncode(sb, fname);
            sb.append(QCOLON).append(value).append(COMMA);
        }
    }

    public static void addFieldWhenGtZero(StringBuilder sb, String fname, Integer value) {
        if (value != null && value > 0) {
            sb.append("\"");
            Encoding.jsonEncode(sb, fname);
            sb.append(QCOLON).append(value).append(COMMA);
        }
    }

    public static void addField(StringBuilder sb, String fname, Long value) {
        if (value != null && value >= 0L) {
            sb.append("\"");
            Encoding.jsonEncode(sb, fname);
            sb.append(QCOLON).append(value).append(COMMA);
        }
    }

    public static void addFieldWhenGtZero(StringBuilder sb, String fname, Long value) {
        if (value != null && value > 0L) {
            sb.append("\"");
            Encoding.jsonEncode(sb, fname);
            sb.append(QCOLON).append(value).append(COMMA);
        }
    }

    public static void addFieldAsNanos(StringBuilder sb, String fname, Duration value) {
        if (value != null && value != Duration.ZERO) {
            sb.append("\"");
            Encoding.jsonEncode(sb, fname);
            sb.append(QCOLON).append(value.toNanos()).append(COMMA);
        }
    }

    public static void addField(StringBuilder sb, String fname, JsonSerializable value) {
        if (value != null) {
            sb.append("\"");
            Encoding.jsonEncode(sb, fname);
            sb.append(QCOLON).append(value.toJson()).append(COMMA);
        }
    }

    public static <T> void _addList(StringBuilder sb, String fname, List<T> list, ListAdder<T> adder) {
        sb.append("\"");
        Encoding.jsonEncode(sb, fname);
        sb.append("\":[");
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                sb.append(COMMA);
            }
            adder.append(sb, list.get(i));
        }
        sb.append("],");
    }

    public static void addStrings(StringBuilder sb, String fname, String[] strArray) {
        if (strArray != null && strArray.length > 0) {
            JsonUtils.addStrings(sb, fname, Arrays.asList(strArray));
        }
    }

    public static void addStrings(StringBuilder sb, String fname, List<String> strings) {
        if (strings != null && strings.size() > 0) {
            JsonUtils._addList(sb, fname, strings, (sbs, s) -> {
                sb.append("\"");
                Encoding.jsonEncode(sb, s);
                sb.append("\"");
            });
        }
    }

    public static void addJsons(StringBuilder sb, String fname, List<? extends JsonSerializable> jsons) {
        if (jsons != null && jsons.size() > 0) {
            JsonUtils._addList(sb, fname, jsons, (sbs, s) -> sbs.append(s.toJson()));
        }
    }

    public static void addDurations(StringBuilder sb, String fname, List<Duration> durations) {
        if (durations != null && durations.size() > 0) {
            JsonUtils._addList(sb, fname, durations, (sbs, dur) -> sbs.append(dur.toNanos()));
        }
    }

    public static void addField(StringBuilder sb, String fname, ZonedDateTime zonedDateTime) {
        if (zonedDateTime != null) {
            sb.append("\"");
            Encoding.jsonEncode(sb, fname);
            sb.append(QCOLONQ).append(DateTimeUtils.toRfc3339(zonedDateTime)).append(QCOMMA);
        }
    }

    public static String readString(String json, Pattern pattern) {
        return JsonUtils.readString(json, pattern, null);
    }

    public static String readString(String json, Pattern pattern, String dflt) {
        Matcher m = pattern.matcher(json);
        return m.find() ? Encoding.jsonDecode(m.group(1)) : dflt;
    }

    public static byte[] readBytes(String json, Pattern pattern) {
        String s = JsonUtils.readString(json, pattern, null);
        return s == null ? null : s.getBytes(StandardCharsets.US_ASCII);
    }

    public static byte[] readBase64(String json, Pattern pattern) {
        Matcher m = pattern.matcher(json);
        String b64 = m.find() ? m.group(1) : null;
        return b64 == null ? null : Base64.getDecoder().decode(b64);
    }

    public static boolean readBoolean(String json, Pattern pattern) {
        Matcher m = pattern.matcher(json);
        return m.find() && Boolean.parseBoolean(m.group(1));
    }

    public static Boolean readBoolean(String json, Pattern pattern, Boolean dflt) {
        Matcher m = pattern.matcher(json);
        if (m.find()) {
            return Boolean.parseBoolean(m.group(1));
        }
        return dflt;
    }

    public static Integer readInteger(String json, Pattern pattern) {
        Matcher m = pattern.matcher(json);
        return m.find() ? Integer.valueOf(Integer.parseInt(m.group(1))) : null;
    }

    public static int readInt(String json, Pattern pattern, int dflt) {
        Matcher m = pattern.matcher(json);
        return m.find() ? Integer.parseInt(m.group(1)) : dflt;
    }

    public static void readInt(String json, Pattern pattern, IntConsumer c) {
        Matcher m = pattern.matcher(json);
        if (m.find()) {
            c.accept(Integer.parseInt(m.group(1)));
        }
    }

    public static Long readLong(String json, Pattern pattern) {
        Matcher m = pattern.matcher(json);
        return m.find() ? JsonUtils.safeParseLong(m.group(1)) : null;
    }

    public static long readLong(String json, Pattern pattern, long dflt) {
        Matcher m = pattern.matcher(json);
        return m.find() ? JsonUtils.safeParseLong(m.group(1), dflt) : dflt;
    }

    public static void readLong(String json, Pattern pattern, LongConsumer c) {
        Long l;
        Matcher m = pattern.matcher(json);
        if (m.find() && (l = JsonUtils.safeParseLong(m.group(1))) != null) {
            c.accept(l);
        }
    }

    public static Long safeParseLong(String s) {
        try {
            return Long.parseLong(s);
        }
        catch (Exception e1) {
            try {
                return Long.parseUnsignedLong(s);
            }
            catch (Exception e2) {
                return null;
            }
        }
    }

    public static long safeParseLong(String s, long dflt) {
        Long l = JsonUtils.safeParseLong(s);
        return l == null ? dflt : l;
    }

    public static ZonedDateTime readDate(String json, Pattern pattern) {
        Matcher m = pattern.matcher(json);
        return m.find() ? DateTimeUtils.parseDateTime(m.group(1)) : null;
    }

    public static Duration readNanos(String json, Pattern pattern) {
        Matcher m = pattern.matcher(json);
        return m.find() ? Duration.ofNanos(Long.parseLong(m.group(1))) : null;
    }

    public static Duration readNanos(String json, Pattern pattern, Duration dflt) {
        Matcher m = pattern.matcher(json);
        return m.find() ? Duration.ofNanos(Long.parseLong(m.group(1))) : dflt;
    }

    public static void readNanos(String json, Pattern pattern, Consumer<Duration> c) {
        Matcher m = pattern.matcher(json);
        if (m.find()) {
            c.accept(Duration.ofNanos(Long.parseLong(m.group(1))));
        }
    }

    public static String normalize(String s) {
        return Character.toString(s.charAt(0)).toUpperCase() + s.substring(1).toLowerCase();
    }

    public static String objectString(String name, Object o) {
        if (o == null) {
            return name + "=null";
        }
        if (o instanceof SequencePair) {
            return o.toString().replace("SequencePair", name);
        }
        return o.toString();
    }

    private static String indent(int level) {
        return level == 0 ? "" : INDENT.substring(0, level * 4);
    }

    public static String getFormatted(Object o) {
        StringBuilder sb = new StringBuilder();
        int level = 0;
        boolean indentNext = true;
        String s = o.toString();
        for (int x = 0; x < s.length(); ++x) {
            char c = s.charAt(x);
            if (c == '{') {
                sb.append(c).append('\n');
                ++level;
                indentNext = true;
                continue;
            }
            if (c == '}') {
                sb.append('\n').append(JsonUtils.indent(--level)).append(c);
                continue;
            }
            if (c == ',') {
                sb.append('\n');
                indentNext = true;
                continue;
            }
            if (indentNext) {
                if (c == ' ') continue;
                sb.append(JsonUtils.indent(level)).append(c);
                indentNext = false;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static void printFormatted(Object o) {
        System.out.println(JsonUtils.getFormatted(o));
    }

    static interface ListAdder<T> {
        public void append(StringBuilder var1, T var2);
    }

    public static enum FieldType {
        jsonString("\"(.+?)\""),
        jsonBoolean("(true|false)"),
        jsonInteger("(-?\\d+)"),
        jsonNumber("(-?\\d+)"),
        jsonStringArray("\\[\\s*(\".+?\")\\s*\\]");

        final String re;

        private FieldType(String re) {
            this.re = re;
        }
    }
}

