/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.support;

import io.nats.client.Message;
import io.nats.client.Options;
import java.time.Duration;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;

public class NatsRequestCompletableFuture
extends CompletableFuture<Message> {
    private static final long DEFAULT_TIMEOUT = Options.DEFAULT_CONNECTION_TIMEOUT.toMillis();
    private final boolean cancelOn503;
    private final long timeOutAfter;
    private boolean wasCancelledClosing;
    private boolean wasCancelledTimedOut;

    public NatsRequestCompletableFuture(boolean cancelOn503, Duration timeout) {
        this.cancelOn503 = cancelOn503;
        this.timeOutAfter = System.currentTimeMillis() + (timeout == null ? DEFAULT_TIMEOUT : timeout.toMillis());
    }

    public void cancelClosing() {
        this.wasCancelledClosing = true;
        this.completeExceptionally(new CancellationException("Future cancelled, connection closing."));
    }

    public void cancelTimedOut() {
        this.wasCancelledTimedOut = true;
        this.completeExceptionally(new CancellationException("Future cancelled, response not registered in time, likely due to server disconnect."));
    }

    public boolean isCancelOn503() {
        return this.cancelOn503;
    }

    public boolean hasExceededTimeout() {
        return System.currentTimeMillis() > this.timeOutAfter;
    }

    public boolean wasCancelledClosing() {
        return this.wasCancelledClosing;
    }

    public boolean wasCancelledTimedOut() {
        return this.wasCancelledTimedOut;
    }
}

