/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.api.DiscardPolicy;
import io.nats.client.api.FeatureConfiguration;
import io.nats.client.api.Placement;
import io.nats.client.api.Republish;
import io.nats.client.api.StorageType;
import io.nats.client.api.StreamConfiguration;
import io.nats.client.support.NatsKeyValueUtil;
import io.nats.client.support.Validator;
import java.time.Duration;

public class KeyValueConfiguration
extends FeatureConfiguration {
    static KeyValueConfiguration instance(String json) {
        return new KeyValueConfiguration(StreamConfiguration.instance(json));
    }

    KeyValueConfiguration(StreamConfiguration sc) {
        super(sc, NatsKeyValueUtil.extractBucketName(sc.getName()));
    }

    public long getMaxHistoryPerKey() {
        return this.sc.getMaxMsgsPerSubject();
    }

    public long getMaxBucketSize() {
        return this.sc.getMaxBytes();
    }

    public long getMaxValueSize() {
        return this.sc.getMaxMsgSize();
    }

    public String toString() {
        return "KeyValueConfiguration{name='" + this.bucketName + '\'' + ", description='" + this.getDescription() + '\'' + ", maxHistoryPerKey=" + this.getMaxHistoryPerKey() + ", maxBucketSize=" + this.getMaxBucketSize() + ", maxValueSize=" + this.getMaxValueSize() + ", ttl=" + this.getTtl() + ", storageType=" + (Object)((Object)this.getStorageType()) + ", replicas=" + this.getReplicas() + ", placement=" + this.getPlacement() + ", republish=" + this.getRepublish() + '}';
    }

    public Republish getRepublish() {
        return this.sc.getRepublish();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(KeyValueConfiguration kvc) {
        return new Builder(kvc);
    }

    public static class Builder {
        String name;
        StreamConfiguration.Builder scBuilder;

        public Builder() {
            this(null);
        }

        public Builder(KeyValueConfiguration kvc) {
            if (kvc == null) {
                this.scBuilder = new StreamConfiguration.Builder();
                this.maxHistoryPerKey(1);
                this.replicas(1);
            } else {
                this.scBuilder = new StreamConfiguration.Builder(kvc.sc);
                this.name = NatsKeyValueUtil.extractBucketName(kvc.sc.getName());
            }
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.scBuilder.description(description);
            return this;
        }

        public Builder maxHistoryPerKey(int maxHistoryPerKey) {
            this.scBuilder.maxMessagesPerSubject(Validator.validateMaxHistory(maxHistoryPerKey));
            return this;
        }

        public Builder maxBucketSize(long maxBucketSize) {
            this.scBuilder.maxBytes(Validator.validateMaxBucketBytes(maxBucketSize));
            return this;
        }

        public Builder maxValueSize(long maxValueSize) {
            this.scBuilder.maxMsgSize(Validator.validateMaxValueSize(maxValueSize));
            return this;
        }

        public Builder ttl(Duration ttl) {
            this.scBuilder.maxAge(ttl);
            return this;
        }

        public Builder storageType(StorageType storageType) {
            this.scBuilder.storageType(storageType);
            return this;
        }

        public Builder replicas(int replicas) {
            this.scBuilder.replicas(Math.max(replicas, 1));
            return this;
        }

        public Builder placement(Placement placement) {
            this.scBuilder.placement(placement);
            return this;
        }

        public Builder republish(Republish republish) {
            this.scBuilder.republish(republish);
            return this;
        }

        public KeyValueConfiguration build() {
            this.name = Validator.validateBucketName(this.name, true);
            this.scBuilder.name(NatsKeyValueUtil.toStreamName(this.name)).subjects(NatsKeyValueUtil.toStreamSubject(this.name)).allowRollup(true).allowDirect(true).discardPolicy(DiscardPolicy.New).denyDelete(true);
            return new KeyValueConfiguration(this.scBuilder.build());
        }
    }
}

