/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.api.KeyValueConfiguration;
import io.nats.client.api.Placement;
import io.nats.client.api.Republish;
import io.nats.client.api.StorageType;
import io.nats.client.api.StreamInfo;
import java.time.Duration;

public class KeyValueStatus {
    private final StreamInfo streamInfo;
    private final KeyValueConfiguration config;

    public KeyValueStatus(StreamInfo si) {
        this.streamInfo = si;
        this.config = new KeyValueConfiguration(this.streamInfo.getConfiguration());
    }

    public String getBucketName() {
        return this.config.getBucketName();
    }

    public String getDescription() {
        return this.config.getDescription();
    }

    public StreamInfo getBackingStreamInfo() {
        return this.streamInfo;
    }

    public KeyValueConfiguration getConfiguration() {
        return this.config;
    }

    public long getEntryCount() {
        return this.streamInfo.getStreamState().getMsgCount();
    }

    public long getMaxHistoryPerKey() {
        return this.config.getMaxHistoryPerKey();
    }

    public long getMaxBucketSize() {
        return this.config.getMaxBucketSize();
    }

    public long getMaxValueSize() {
        return this.config.getMaxValueSize();
    }

    public Duration getTtl() {
        return this.config.getTtl();
    }

    public StorageType getStorageType() {
        return this.config.getStorageType();
    }

    public int getReplicas() {
        return this.config.getReplicas();
    }

    public Placement getPlacement() {
        return this.config.getPlacement();
    }

    public Republish getRepublish() {
        return this.config.getRepublish();
    }

    public String getBackingStore() {
        return "JetStream";
    }

    public String toString() {
        return "KeyValueStatus{name='" + this.getBucketName() + '\'' + ", description='" + this.getDescription() + '\'' + ", entryCount=" + this.getEntryCount() + ", maxHistoryPerKey=" + this.getMaxHistoryPerKey() + ", maxBucketSize=" + this.getMaxBucketSize() + ", maxValueSize=" + this.getMaxValueSize() + ", ttl=" + this.getTtl() + ", storageType=" + (Object)((Object)this.getStorageType()) + ", replicas=" + this.getReplicas() + '}';
    }
}

