/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import io.nats.client.support.Validator;

public class BaseConsumeOptions {
    public static final int DEFAULT_MESSAGE_COUNT = 100;
    public static final int DEFAULT_THRESHOLD_PERCENT = 25;
    public static final long DEFAULT_EXPIRES_IN_MS = 30000L;
    public static final long MIN_EXPIRES_MILLS = 1000L;
    public static final long MAX_EXPIRES_MILLIS = 60000L;
    public static final int MAX_IDLE_HEARTBEAT_PCT = 50;
    protected final int messages;
    protected final int bytes;
    protected final long expiresIn;
    protected final long idleHeartbeat;
    protected final int thresholdPercent;

    protected BaseConsumeOptions(Builder b) {
        this.messages = b.messages == -1 ? 100 : Validator.validateGtZero(b.messages, "Batch Size or Max Message Count");
        int n = this.bytes = b.bytes == -1 ? 0 : (int)Validator.validateGtEqZero(b.bytes, "Max Bytes");
        if (b.thresholdPct == -1) {
            this.thresholdPercent = 25;
        } else if (b.thresholdPct >= 1 && b.thresholdPct <= 100) {
            this.thresholdPercent = b.thresholdPct;
        } else {
            throw new IllegalArgumentException("Threshold percent must be between 1 and 100 inclusive.");
        }
        if (b.expiresIn == -1L) {
            this.expiresIn = 30000L;
        } else if (b.expiresIn >= 1000L && b.expiresIn <= 60000L) {
            this.expiresIn = b.expiresIn;
        } else {
            throw new IllegalArgumentException("Expires must be between 1000 and 60000 seconds inclusive.");
        }
        this.idleHeartbeat = this.expiresIn * 50L / 100L;
    }

    public long getExpires() {
        return this.expiresIn;
    }

    public long getIdleHeartbeat() {
        return this.idleHeartbeat;
    }

    public int getThresholdPercent() {
        return this.thresholdPercent;
    }

    protected static abstract class Builder<B, CO> {
        private int messages = -1;
        private int bytes = -1;
        private int thresholdPct = -1;
        private long expiresIn = -1L;

        protected Builder() {
        }

        protected abstract B getThis();

        protected B messages(int messages) {
            this.messages = messages;
            return this.getThis();
        }

        protected B bytes(int bytes, int messages) {
            this.bytes = bytes;
            this.messages = messages;
            return this.getThis();
        }

        public B expiresIn(long expiresInMillis) {
            this.expiresIn = expiresInMillis;
            return this.getThis();
        }

        public B thresholdPercent(int thresholdPct) {
            this.thresholdPct = thresholdPct;
            return this.getThis();
        }

        public abstract CO build();
    }
}

