/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.ConsumeOptions;
import io.nats.client.ConsumerContext;
import io.nats.client.Dispatcher;
import io.nats.client.FetchConsumeOptions;
import io.nats.client.FetchConsumer;
import io.nats.client.JetStreamApiException;
import io.nats.client.JetStreamOptions;
import io.nats.client.ManualConsumer;
import io.nats.client.MessageHandler;
import io.nats.client.PullSubscribeOptions;
import io.nats.client.SimpleConsumer;
import io.nats.client.api.ConsumerConfiguration;
import io.nats.client.api.ConsumerInfo;
import io.nats.client.impl.NatsConnection;
import io.nats.client.impl.NatsFetchConsumer;
import io.nats.client.impl.NatsJetStream;
import io.nats.client.impl.NatsJetStreamPullSubscription;
import io.nats.client.impl.NatsManualConsumer;
import io.nats.client.impl.NatsSimpleConsumer;
import io.nats.client.impl.NatsStreamContext;
import io.nats.client.support.Validator;
import java.io.IOException;

public class NatsConsumerContext
extends NatsStreamContext
implements ConsumerContext {
    private final NatsJetStream js;
    private final ConsumerConfiguration userCc;
    private String consumer;

    NatsConsumerContext(NatsStreamContext streamContext, String consumerName, ConsumerConfiguration cc) throws IOException, JetStreamApiException {
        super(streamContext);
        this.js = new NatsJetStream(this.jsm.conn, this.jsm.jso);
        if (consumerName != null) {
            this.consumer = consumerName;
            this.userCc = null;
            this.jsm.getConsumerInfo(this.stream, this.consumer);
        } else {
            this.userCc = cc;
        }
    }

    private NatsConsumerContext(NatsConnection connection, JetStreamOptions jsOptions, String streamName, String consumerName, ConsumerConfiguration cc) throws IOException, JetStreamApiException {
        this(new NatsStreamContext(connection, jsOptions, streamName), consumerName, cc);
    }

    NatsConsumerContext(NatsConnection connection, JetStreamOptions jsOptions, String stream, String consumerName) throws IOException, JetStreamApiException {
        this(connection, jsOptions, stream, Validator.required(consumerName, "Consumer Name"), null);
    }

    NatsConsumerContext(NatsConnection connection, JetStreamOptions jsOptions, String stream, ConsumerConfiguration consumerConfiguration) throws IOException, JetStreamApiException {
        this(connection, jsOptions, stream, null, Validator.required(consumerConfiguration, "Consumer Configuration"));
    }

    @Override
    public String getName() {
        return this.consumer;
    }

    @Override
    public ConsumerInfo getConsumerInfo() throws IOException, JetStreamApiException {
        return this.jsm.getConsumerInfo(this.stream, this.consumer);
    }

    @Override
    public FetchConsumer fetch(int maxMessages) throws IOException, JetStreamApiException {
        return this.fetch(FetchConsumeOptions.builder().maxMessages(maxMessages).build());
    }

    @Override
    public FetchConsumer fetch(int maxBytes, int maxMessages) throws IOException, JetStreamApiException {
        return this.fetch(FetchConsumeOptions.builder().maxBytes(maxBytes, maxMessages).build());
    }

    @Override
    public FetchConsumer fetch(FetchConsumeOptions consumeOptions) throws IOException, JetStreamApiException {
        Validator.required(consumeOptions, "Fetch Consume Options");
        return new NatsFetchConsumer(new Mediator(), consumeOptions);
    }

    @Override
    public ManualConsumer consume() throws IOException, JetStreamApiException {
        return new NatsManualConsumer(new Mediator(), ConsumeOptions.DEFAULT_CONSUME_OPTIONS);
    }

    @Override
    public ManualConsumer consume(ConsumeOptions consumeOptions) throws IOException, JetStreamApiException {
        Validator.required(consumeOptions, "Consume Options");
        return new NatsManualConsumer(new Mediator(), consumeOptions);
    }

    @Override
    public SimpleConsumer consume(MessageHandler handler) throws IOException, JetStreamApiException {
        Validator.required(handler, "Message Handler");
        return new NatsSimpleConsumer(new Mediator(), handler, ConsumeOptions.DEFAULT_CONSUME_OPTIONS);
    }

    @Override
    public SimpleConsumer consume(MessageHandler handler, ConsumeOptions consumeOptions) throws IOException, JetStreamApiException {
        Validator.required(handler, "Message Handler");
        Validator.required(consumeOptions, "Consume Options");
        return new NatsSimpleConsumer(new Mediator(), handler, consumeOptions);
    }

    class Mediator {
        Dispatcher dispatcher;

        Mediator() {
        }

        public NatsJetStreamPullSubscription makeSubscription(MessageHandler messageHandler) throws IOException, JetStreamApiException {
            PullSubscribeOptions pso = NatsConsumerContext.this.consumer == null ? ConsumerConfiguration.builder(NatsConsumerContext.this.userCc).buildPullSubscribeOptions(NatsConsumerContext.this.stream) : PullSubscribeOptions.bind(NatsConsumerContext.this.stream, NatsConsumerContext.this.consumer);
            if (messageHandler == null) {
                return (NatsJetStreamPullSubscription)NatsConsumerContext.this.js.subscribe(null, pso);
            }
            this.dispatcher = ((NatsConsumerContext)NatsConsumerContext.this).js.conn.createDispatcher();
            return (NatsJetStreamPullSubscription)NatsConsumerContext.this.js.subscribe(null, this.dispatcher, messageHandler, pso);
        }
    }
}

