/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.ConsumeOptions;
import io.nats.client.JetStreamApiException;
import io.nats.client.MessageHandler;
import io.nats.client.PullRequestOptions;
import io.nats.client.impl.NatsConsumerContext;
import io.nats.client.impl.NatsSimpleConsumerBase;
import java.io.IOException;

class NatsSimpleConsumer
extends NatsSimpleConsumerBase {
    protected final PullRequestOptions repullPro;
    protected final int thresholdMessages;
    protected final int thresholdBytes;
    protected final NatsConsumerContext.Mediator mediator;

    NatsSimpleConsumer(NatsConsumerContext.Mediator mediator, MessageHandler messageHandler, ConsumeOptions opts) throws IOException, JetStreamApiException {
        this.mediator = mediator;
        if (messageHandler == null) {
            this.initSub(mediator.makeSubscription(null));
        } else {
            this.initSub(mediator.makeSubscription(msg -> {
                this.checkForRepull();
                messageHandler.onMessage(msg);
            }));
        }
        int bm = opts.getBatchSize();
        int bb = opts.getBatchBytes();
        PullRequestOptions firstPro = PullRequestOptions.builder(bm).maxBytes(bb).expiresIn(opts.getExpires()).idleHeartbeat(opts.getIdleHeartbeat()).build();
        int repullMessages = Math.max(1, bm * opts.getThresholdPercent() / 100);
        int repullBytes = bb == 0 ? 0 : Math.max(1, bb * opts.getThresholdPercent() / 100);
        this.repullPro = PullRequestOptions.builder(repullMessages).maxBytes(repullBytes).expiresIn(opts.getExpires()).idleHeartbeat(opts.getIdleHeartbeat()).build();
        this.thresholdMessages = bm - repullMessages;
        this.thresholdBytes = bb == 0 ? Integer.MIN_VALUE : bb - repullBytes;
        this.sub.pull(firstPro);
    }

    protected void checkForRepull() {
        if (this.active && (this.pmm.pendingMessages <= (long)this.thresholdMessages || this.pmm.pendingBytes <= (long)this.thresholdBytes)) {
            this.sub.pull(this.repullPro);
        }
    }
}

