/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.ConsumerContext;
import io.nats.client.JetStreamApiException;
import io.nats.client.JetStreamOptions;
import io.nats.client.StreamContext;
import io.nats.client.api.ConsumerConfiguration;
import io.nats.client.api.ConsumerInfo;
import io.nats.client.api.StreamInfo;
import io.nats.client.api.StreamInfoOptions;
import io.nats.client.impl.NatsConnection;
import io.nats.client.impl.NatsConsumerContext;
import io.nats.client.impl.NatsJetStreamManagement;
import java.io.IOException;

class NatsStreamContext
implements StreamContext {
    final NatsJetStreamManagement jsm;
    final String stream;

    NatsStreamContext(NatsConnection connection, JetStreamOptions jsOptions, String stream) throws IOException, JetStreamApiException {
        this.jsm = new NatsJetStreamManagement(connection, jsOptions);
        this.stream = stream;
        this.jsm.getStreamInfo(stream);
    }

    NatsStreamContext(NatsStreamContext streamContext) throws IOException, JetStreamApiException {
        this.jsm = streamContext.jsm;
        this.stream = streamContext.stream;
    }

    @Override
    public String getStream() {
        return this.stream;
    }

    @Override
    public StreamInfo getStreamInfo() throws IOException, JetStreamApiException {
        return this.jsm.getStreamInfo(this.stream);
    }

    @Override
    public StreamInfo getStreamInfo(StreamInfoOptions options) throws IOException, JetStreamApiException {
        return this.jsm.getStreamInfo(this.stream, options);
    }

    @Override
    public ConsumerInfo createConsumer(ConsumerConfiguration config) throws IOException, JetStreamApiException {
        return this.jsm.addOrUpdateConsumer(this.stream, config);
    }

    @Override
    public boolean deleteConsumer(String consumerName) throws IOException, JetStreamApiException {
        return this.jsm.deleteConsumer(this.stream, consumerName);
    }

    @Override
    public ConsumerContext getConsumerContext(String consumerName) throws IOException, JetStreamApiException {
        return new NatsConsumerContext(this.jsm.conn, this.jsm.jso, this.stream, consumerName);
    }
}

