/*
 * Decompiled with CFR 0.152.
 */
package io.nats.service;

import io.nats.client.support.JsonUtils;
import io.nats.client.support.JsonValue;
import io.nats.client.support.JsonValueUtils;
import io.nats.service.ServiceResponse;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class InfoResponse
extends ServiceResponse {
    public static final String TYPE = "io.nats.micro.v1.info_response";
    private final String description;
    private final List<String> subjects;

    public InfoResponse(String id, String name, String version, Map<String, String> metadata, String description, List<String> subjects) {
        super(TYPE, id, name, version, metadata);
        this.description = description;
        this.subjects = subjects;
    }

    public InfoResponse(byte[] jsonBytes) {
        this(InfoResponse.parseMessage(jsonBytes));
    }

    private InfoResponse(JsonValue jv) {
        super(TYPE, jv);
        this.description = JsonValueUtils.readString(jv, "description");
        this.subjects = JsonValueUtils.readStringList(jv, "subjects");
    }

    @Override
    protected void subToJson(StringBuilder sb) {
        JsonUtils.addField(sb, "description", this.description);
        JsonUtils.addStrings(sb, "subjects", this.subjects);
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getSubjects() {
        return this.subjects;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InfoResponse that = (InfoResponse)o;
        if (!Objects.equals(this.description, that.description)) {
            return false;
        }
        return Objects.equals(this.subjects, that.subjects);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.subjects != null ? this.subjects.hashCode() : 0);
        return result;
    }
}

