/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import io.nats.client.Options;
import io.nats.client.support.Validator;
import java.time.Duration;

public class JetStreamOptions {
    public static final Duration DEFAULT_TIMEOUT = Options.DEFAULT_CONNECTION_TIMEOUT;
    public static final JetStreamOptions DEFAULT_JS_OPTIONS = new Builder().build();
    private final String jsPrefix;
    private final Duration requestTimeout;
    private final boolean publishNoAck;
    private final boolean defaultPrefix;
    private final boolean optOut290ConsumerCreate;

    private JetStreamOptions(Builder b) {
        if (b.jsPrefix == null) {
            this.defaultPrefix = true;
            this.jsPrefix = "$JS.API.";
        } else {
            this.defaultPrefix = false;
            this.jsPrefix = b.jsPrefix;
        }
        this.requestTimeout = b.requestTimeout;
        this.publishNoAck = b.publishNoAck;
        this.optOut290ConsumerCreate = b.optOut290ConsumerCreate;
    }

    public Duration getRequestTimeout() {
        return this.requestTimeout;
    }

    public String getPrefix() {
        return this.jsPrefix;
    }

    public boolean isDefaultPrefix() {
        return this.defaultPrefix;
    }

    public boolean isPublishNoAck() {
        return this.publishNoAck;
    }

    public boolean isOptOut290ConsumerCreate() {
        return this.optOut290ConsumerCreate;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(JetStreamOptions jso) {
        return new Builder(jso);
    }

    public static JetStreamOptions defaultOptions() {
        return DEFAULT_JS_OPTIONS;
    }

    public static String convertDomainToPrefix(String domain) {
        String valid = Validator.validatePrefixOrDomain(domain, "Domain", false);
        return valid == null ? null : "$JS." + Validator.ensureEndsWithDot(valid) + "API";
    }

    public static class Builder {
        private String jsPrefix;
        private Duration requestTimeout;
        private boolean publishNoAck;
        private boolean optOut290ConsumerCreate;

        public Builder() {
        }

        public Builder(JetStreamOptions jso) {
            if (jso != null) {
                this.jsPrefix = jso.isDefaultPrefix() ? null : jso.jsPrefix;
                this.requestTimeout = jso.requestTimeout;
                this.publishNoAck = jso.publishNoAck;
                this.optOut290ConsumerCreate = jso.optOut290ConsumerCreate;
            }
        }

        public Builder requestTimeout(Duration requestTimeout) {
            this.requestTimeout = requestTimeout;
            return this;
        }

        public Builder prefix(String prefix) {
            this.jsPrefix = Validator.ensureEndsWithDot(Validator.validatePrefixOrDomain(prefix, "Prefix", false));
            return this;
        }

        public Builder domain(String domain) {
            String prefix = JetStreamOptions.convertDomainToPrefix(domain);
            this.jsPrefix = prefix == null ? null : prefix + ".";
            return this;
        }

        public Builder publishNoAck(boolean publishNoAck) {
            this.publishNoAck = publishNoAck;
            return this;
        }

        public Builder optOut290ConsumerCreate(boolean optOut) {
            this.optOut290ConsumerCreate = optOut;
            return this;
        }

        public JetStreamOptions build() {
            this.requestTimeout = this.requestTimeout == null ? DEFAULT_TIMEOUT : this.requestTimeout;
            return new JetStreamOptions(this);
        }
    }
}

