/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.FetchConsumeOptions;
import io.nats.client.FetchConsumer;
import io.nats.client.JetStreamApiException;
import io.nats.client.Message;
import io.nats.client.PullRequestOptions;
import io.nats.client.impl.NatsConsumerContext;
import io.nats.client.impl.NatsSimpleConsumerBase;
import java.io.IOException;

class NatsFetchConsumer
extends NatsSimpleConsumerBase
implements FetchConsumer {
    private final long maxWaitNanos;
    private final long start;

    public NatsFetchConsumer(NatsConsumerContext.Mediator mediator, FetchConsumeOptions consumeOptions) throws IOException, JetStreamApiException {
        this.initSub(mediator.makeSubscription(null));
        this.maxWaitNanos = consumeOptions.getExpires() * 1000000L;
        this.sub.pull(PullRequestOptions.builder(consumeOptions.getMaxMessages()).maxBytes(consumeOptions.getMaxBytes()).expiresIn(consumeOptions.getExpires()).idleHeartbeat(consumeOptions.getIdleHeartbeat()).build());
        this.start = System.nanoTime();
    }

    @Override
    public Message nextMessage() throws InterruptedException {
        long timeLeftMillis;
        Message m = this.pmm.pendingMessages < 1L || this.pmm.trackingBytes && this.pmm.pendingBytes < 1L ? this.sub.nextMessage(null) : ((timeLeftMillis = (this.maxWaitNanos - (System.nanoTime() - this.start)) / 1000000L) < 1L ? this.sub.nextMessage(null) : this.sub.nextMessage(timeLeftMillis));
        if (m == null) {
            this.sub.connection.getExecutor().submit(() -> this.unsubscribe(-1));
        }
        return m;
    }
}

