/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.JetStreamApiException;
import io.nats.client.JetStreamReader;
import io.nats.client.JetStreamSubscription;
import io.nats.client.Message;
import io.nats.client.PullRequestOptions;
import io.nats.client.api.ConsumerInfo;
import io.nats.client.impl.MessageManager;
import io.nats.client.impl.NatsConnection;
import io.nats.client.impl.NatsDispatcher;
import io.nats.client.impl.NatsJetStream;
import io.nats.client.impl.NatsMessage;
import io.nats.client.impl.NatsSubscription;
import io.nats.client.support.NatsJetStreamConstants;
import java.io.IOException;
import java.time.Duration;
import java.util.Iterator;
import java.util.List;

public class NatsJetStreamSubscription
extends NatsSubscription
implements JetStreamSubscription,
NatsJetStreamConstants {
    public static final String SUBSCRIPTION_TYPE_DOES_NOT_SUPPORT_PULL = "Subscription type does not support pull.";
    protected final NatsJetStream js;
    protected String stream;
    protected String consumerName;
    protected MessageManager manager;
    protected static final long MIN_MILLIS = 20L;
    protected static final long EXPIRE_LESS_MILLIS = 10L;

    NatsJetStreamSubscription(String sid, String subject, String queueName, NatsConnection connection, NatsDispatcher dispatcher, NatsJetStream js, String stream, String consumer, MessageManager manager) {
        super(sid, subject, queueName, connection, dispatcher);
        this.js = js;
        this.stream = stream;
        this.consumerName = consumer;
        this.manager = manager;
        manager.startup(this);
    }

    void setConsumerName(String consumerName) {
        this.consumerName = consumerName;
    }

    @Override
    public String getConsumerName() {
        return this.consumerName;
    }

    String getStream() {
        return this.stream;
    }

    boolean isPullMode() {
        return false;
    }

    MessageManager getManager() {
        return this.manager;
    }

    @Override
    void invalidate() {
        this.manager.shutdown();
        super.invalidate();
    }

    @Override
    public Message nextMessage(Duration timeout) throws InterruptedException, IllegalStateException {
        if (timeout == null || timeout.toMillis() <= 0L) {
            return this._nextUnmanagedNullOrLteZero(timeout);
        }
        return this._nextUnmanaged(timeout.toMillis(), null);
    }

    @Override
    public Message nextMessage(long timeoutMillis) throws InterruptedException, IllegalStateException {
        if (timeoutMillis <= 0L) {
            return this._nextUnmanagedNullOrLteZero(Duration.ZERO);
        }
        return this._nextUnmanaged(timeoutMillis, null);
    }

    protected Message _nextUnmanagedNullOrLteZero(Duration timeout) throws InterruptedException {
        NatsMessage msg;
        do {
            if ((msg = this.nextMessageInternal(timeout)) != null) continue;
            return null;
        } while (this.manager.manage(msg) != MessageManager.ManageResult.MESSAGE);
        return msg;
    }

    protected Message _nextUnmanaged(long timeout, String replyMatch) throws InterruptedException {
        long timeoutNanos;
        long start = System.nanoTime();
        long timeLeftNanos = timeoutNanos = timeout * 1000000L;
        while (timeLeftNanos > 0L) {
            NatsMessage msg = this.nextMessageInternal(Duration.ofNanos(timeLeftNanos));
            if (msg == null) {
                return null;
            }
            switch (this.manager.manage(msg)) {
                case MESSAGE: {
                    return msg;
                }
                case TERMINUS: 
                case ERROR: {
                    if (replyMatch == null || !replyMatch.equals(msg.getSubject())) break;
                    return null;
                }
            }
            timeLeftNanos = timeoutNanos - (System.nanoTime() - start);
        }
        return null;
    }

    @Override
    public void pull(int batchSize) {
        throw new IllegalStateException(SUBSCRIPTION_TYPE_DOES_NOT_SUPPORT_PULL);
    }

    @Override
    public void pull(PullRequestOptions pullRequestOptions) {
        throw new IllegalStateException(SUBSCRIPTION_TYPE_DOES_NOT_SUPPORT_PULL);
    }

    @Override
    public void pullNoWait(int batchSize) {
        throw new IllegalStateException(SUBSCRIPTION_TYPE_DOES_NOT_SUPPORT_PULL);
    }

    @Override
    public void pullNoWait(int batchSize, Duration expiresIn) {
        throw new IllegalStateException(SUBSCRIPTION_TYPE_DOES_NOT_SUPPORT_PULL);
    }

    @Override
    public void pullNoWait(int batchSize, long expiresInMillis) {
        throw new IllegalStateException(SUBSCRIPTION_TYPE_DOES_NOT_SUPPORT_PULL);
    }

    @Override
    public void pullExpiresIn(int batchSize, Duration expiresIn) {
        throw new IllegalStateException(SUBSCRIPTION_TYPE_DOES_NOT_SUPPORT_PULL);
    }

    @Override
    public void pullExpiresIn(int batchSize, long expiresInMillis) {
        throw new IllegalStateException(SUBSCRIPTION_TYPE_DOES_NOT_SUPPORT_PULL);
    }

    @Override
    public List<Message> fetch(int batchSize, long maxWaitMillis) {
        throw new IllegalStateException(SUBSCRIPTION_TYPE_DOES_NOT_SUPPORT_PULL);
    }

    @Override
    public List<Message> fetch(int batchSize, Duration maxWait) {
        throw new IllegalStateException(SUBSCRIPTION_TYPE_DOES_NOT_SUPPORT_PULL);
    }

    @Override
    public Iterator<Message> iterate(int batchSize, Duration maxWait) {
        throw new IllegalStateException(SUBSCRIPTION_TYPE_DOES_NOT_SUPPORT_PULL);
    }

    @Override
    public Iterator<Message> iterate(int batchSize, long maxWaitMillis) {
        throw new IllegalStateException(SUBSCRIPTION_TYPE_DOES_NOT_SUPPORT_PULL);
    }

    @Override
    public JetStreamReader reader(int batchSize, int repullAt) {
        throw new IllegalStateException(SUBSCRIPTION_TYPE_DOES_NOT_SUPPORT_PULL);
    }

    @Override
    public ConsumerInfo getConsumerInfo() throws IOException, JetStreamApiException {
        return this.js.lookupConsumerInfo(this.stream, this.consumerName);
    }

    public String toString() {
        return "NatsJetStreamSubscription{consumer='" + this.consumerName + '\'' + ", stream='" + this.stream + '\'' + ", deliver='" + this.getSubject() + '\'' + ", isPullMode=" + this.isPullMode() + '}';
    }
}

