/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.JetStreamApiException;
import io.nats.client.SimpleConsumer;
import io.nats.client.api.ConsumerInfo;
import io.nats.client.impl.NatsJetStreamPullSubscription;
import io.nats.client.impl.PullMessageManager;
import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;

class NatsSimpleConsumerBase
implements SimpleConsumer {
    protected NatsJetStreamPullSubscription sub;
    protected PullMessageManager pmm;
    protected final Object subLock = new Object();
    protected boolean active = true;

    NatsSimpleConsumerBase() {
    }

    protected void initSub(NatsJetStreamPullSubscription sub) {
        this.sub = sub;
        this.pmm = (PullMessageManager)sub.manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConsumerInfo getConsumerInfo() throws IOException, JetStreamApiException {
        Object object = this.subLock;
        synchronized (object) {
            return this.sub.getConsumerInfo();
        }
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void unsubscribe() {
        this.unsubscribe(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unsubscribe(int after) {
        Object object = this.subLock;
        synchronized (object) {
            this.active = false;
            if (this.sub.getNatsDispatcher() != null) {
                this.sub.getDispatcher().unsubscribe(this.sub, after);
            } else {
                this.sub.unsubscribe(after);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Boolean> drain(Duration timeout) throws InterruptedException {
        Object object = this.subLock;
        synchronized (object) {
            this.active = false;
            if (this.sub.getNatsDispatcher() != null) {
                return this.sub.getDispatcher().drain(timeout);
            }
            return this.sub.drain(timeout);
        }
    }
}

