/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.support;

import io.nats.client.impl.Headers;
import java.util.List;

public class HttpRequest {
    private String method = "GET";
    private String uri = "/";
    private String version = "1.1";
    private final Headers headers = new Headers();

    public Headers getHeaders() {
        return this.headers;
    }

    public String getMethod() {
        return this.method;
    }

    public HttpRequest method(String method) {
        if (null == method) {
            throw new IllegalArgumentException("HttpRequest method must be non-null");
        }
        this.method = method.trim().toUpperCase();
        return this;
    }

    public String getURI() {
        return this.uri;
    }

    public HttpRequest uri(String uri) {
        if (null == uri) {
            throw new IllegalArgumentException("HttpRequest uri must be non-null");
        }
        this.uri = uri;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public HttpRequest version(String version) {
        if (null == version) {
            throw new IllegalArgumentException("HttpRequest version must be non-null");
        }
        this.version = version;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.method);
        sb.append(" ");
        sb.append(this.uri);
        sb.append(" HTTP/");
        sb.append(this.version);
        sb.append("\r\n");
        for (String key : this.headers.keySet()) {
            List<String> values = this.headers.get(key);
            for (String value : values) {
                sb.append(key);
                sb.append(": ");
                sb.append(value);
                sb.append("\r\n");
            }
        }
        sb.append("\r\n");
        return sb.toString();
    }
}

