/*
 * Decompiled with CFR 0.152.
 */
package io.nats.service;

import io.nats.client.Connection;
import io.nats.client.Message;
import io.nats.client.Subscription;
import io.nats.client.impl.AckType;
import io.nats.client.impl.Headers;
import io.nats.client.impl.NatsJetStreamMetaData;
import io.nats.client.impl.NatsMessage;
import io.nats.client.support.JsonSerializable;
import io.nats.client.support.Status;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.concurrent.TimeoutException;

public class ServiceMessage
implements Message {
    public static final String NATS_SERVICE_ERROR = "Nats-Service-Error";
    public static final String NATS_SERVICE_ERROR_CODE = "Nats-Service-Error-Code";
    private final Message message;

    ServiceMessage(Message message) {
        this.message = message;
    }

    public void respond(Connection conn, byte[] response) {
        conn.publish(this.message.getReplyTo(), response);
    }

    public void respond(Connection conn, String response) {
        conn.publish(this.message.getReplyTo(), response.getBytes(StandardCharsets.UTF_8));
    }

    public void respond(Connection conn, JsonSerializable response) {
        conn.publish(this.message.getReplyTo(), response.serialize());
    }

    public void respond(Connection conn, byte[] response, Headers headers) {
        conn.publish(NatsMessage.builder().subject(this.message.getReplyTo()).data(response).headers(headers).build());
    }

    public void respond(Connection conn, String response, Headers headers) {
        conn.publish(NatsMessage.builder().subject(this.message.getReplyTo()).data(response).headers(headers).build());
    }

    public void respond(Connection conn, JsonSerializable response, Headers headers) {
        conn.publish(NatsMessage.builder().subject(this.message.getReplyTo()).data(response.serialize()).headers(headers).build());
    }

    public void respondStandardError(Connection conn, String errorMessage, int errorCode) {
        conn.publish(NatsMessage.builder().subject(this.message.getReplyTo()).headers(new Headers().put(NATS_SERVICE_ERROR, errorMessage).put(NATS_SERVICE_ERROR_CODE, "" + errorCode)).build());
    }

    @Override
    public String getSubject() {
        return this.message.getSubject();
    }

    @Override
    public String getReplyTo() {
        return this.message.getReplyTo();
    }

    @Override
    public boolean hasHeaders() {
        return this.message.hasHeaders();
    }

    @Override
    public Headers getHeaders() {
        return this.message.getHeaders();
    }

    @Override
    public boolean isStatusMessage() {
        return this.message.isStatusMessage();
    }

    @Override
    public Status getStatus() {
        return this.message.getStatus();
    }

    @Override
    public byte[] getData() {
        return this.message.getData();
    }

    @Override
    public boolean isUtf8mode() {
        return this.message.isUtf8mode();
    }

    @Override
    public Subscription getSubscription() {
        return this.message.getSubscription();
    }

    @Override
    public String getSID() {
        return this.message.getSID();
    }

    @Override
    public Connection getConnection() {
        return this.message.getConnection();
    }

    @Override
    public NatsJetStreamMetaData metaData() {
        return this.message.metaData();
    }

    @Override
    public AckType lastAck() {
        return this.message.lastAck();
    }

    @Override
    public void ack() {
        this.message.ack();
    }

    @Override
    public void ackSync(Duration timeout) throws TimeoutException, InterruptedException {
        this.message.ackSync(timeout);
    }

    @Override
    public void nak() {
        this.message.nak();
    }

    @Override
    public void nakWithDelay(Duration nakDelay) {
        this.message.nakWithDelay(nakDelay);
    }

    @Override
    public void nakWithDelay(long nakDelayMillis) {
        this.message.nakWithDelay(nakDelayMillis);
    }

    @Override
    public void term() {
        this.message.term();
    }

    @Override
    public void inProgress() {
        this.message.inProgress();
    }

    @Override
    public boolean isJetStream() {
        return this.message.isJetStream();
    }
}

