/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import io.nats.client.api.AckPolicy;
import io.nats.client.api.ConsumerConfiguration;
import io.nats.client.support.NatsJetStreamClientError;
import io.nats.client.support.Validator;
import java.time.Duration;

public abstract class SubscribeOptions {
    public static final long DEFAULT_ORDERED_HEARTBEAT = 5000L;
    protected final String stream;
    protected final boolean pull;
    protected final boolean bind;
    protected final boolean ordered;
    protected final long messageAlarmTime;
    protected final ConsumerConfiguration consumerConfig;
    protected final long pendingMessageLimit;
    protected final long pendingByteLimit;

    protected SubscribeOptions(Builder builder, boolean isPull, String deliverSubject, String deliverGroup, long pendingMessageLimit, long pendingByteLimit) {
        this.pull = isPull;
        this.bind = builder.bind;
        this.ordered = builder.ordered;
        this.messageAlarmTime = builder.messageAlarmTime;
        if (this.ordered && this.bind) {
            throw NatsJetStreamClientError.JsSoOrderedNotAllowedWithBind.instance();
        }
        this.stream = Validator.validateStreamName(builder.stream, this.bind);
        String durable = Validator.validateMustMatchIfBothSupplied(builder.durable, builder.cc == null ? null : builder.cc.getDurable(), NatsJetStreamClientError.JsSoDurableMismatch);
        durable = Validator.validateDurable(durable, this.bind);
        String name = Validator.validateMustMatchIfBothSupplied(builder.name, builder.cc == null ? null : builder.cc.getName(), NatsJetStreamClientError.JsSoNameMismatch);
        Validator.validateMustMatchIfBothSupplied(name, durable, NatsJetStreamClientError.JsConsumerNameDurableMismatch);
        deliverGroup = Validator.validateMustMatchIfBothSupplied(deliverGroup, builder.cc == null ? null : builder.cc.getDeliverGroup(), NatsJetStreamClientError.JsSoDeliverGroupMismatch);
        deliverSubject = Validator.validateMustMatchIfBothSupplied(deliverSubject, builder.cc == null ? null : builder.cc.getDeliverSubject(), NatsJetStreamClientError.JsSoDeliverSubjectMismatch);
        this.pendingMessageLimit = pendingMessageLimit;
        this.pendingByteLimit = pendingByteLimit;
        if (this.ordered) {
            Validator.validateNotSupplied(deliverGroup, NatsJetStreamClientError.JsSoOrderedNotAllowedWithDeliverGroup);
            Validator.validateNotSupplied(durable, NatsJetStreamClientError.JsSoOrderedNotAllowedWithDurable);
            Validator.validateNotSupplied(deliverSubject, NatsJetStreamClientError.JsSoOrderedNotAllowedWithDeliverSubject);
            long hb = 5000L;
            if (builder.cc != null) {
                if (builder.cc.ackPolicyWasSet() && builder.cc.getAckPolicy() != AckPolicy.None) {
                    throw NatsJetStreamClientError.JsSoOrderedRequiresAckPolicyNone.instance();
                }
                if (builder.cc.getMaxDeliver() > 1L) {
                    throw NatsJetStreamClientError.JsSoOrderedRequiresMaxDeliver.instance();
                }
                if (builder.cc.memStorageWasSet() && !builder.cc.isMemStorage()) {
                    throw NatsJetStreamClientError.JsSoOrderedMemStorageNotSuppliedOrTrue.instance();
                }
                if (builder.cc.numReplicasWasSet() && builder.cc.getNumReplicas() != 1) {
                    throw NatsJetStreamClientError.JsSoOrderedReplicasNotSuppliedOrOne.instance();
                }
                Duration ccHb = builder.cc.getIdleHeartbeat();
                if (ccHb != null) {
                    hb = ccHb.toMillis();
                }
            }
            this.consumerConfig = ConsumerConfiguration.builder(builder.cc).ackPolicy(AckPolicy.None).maxDeliver(1L).flowControl(hb).ackWait(Duration.ofHours(22L)).name(name).memStorage(true).numReplicas(1).build();
        } else {
            this.consumerConfig = ConsumerConfiguration.builder(builder.cc).durable(durable).deliverSubject(deliverSubject).deliverGroup(deliverGroup).name(name).build();
        }
    }

    public String getStream() {
        return this.stream;
    }

    public String getDurable() {
        return this.consumerConfig.getDurable();
    }

    public boolean isPull() {
        return this.pull;
    }

    public boolean isBind() {
        return this.bind;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public long getMessageAlarmTime() {
        return this.messageAlarmTime;
    }

    public ConsumerConfiguration getConsumerConfiguration() {
        return this.consumerConfig;
    }

    public long getPendingMessageLimit() {
        return this.pendingMessageLimit;
    }

    public long getPendingByteLimit() {
        return this.pendingByteLimit;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{stream='" + this.stream + '\'' + "bind=" + this.bind + ", " + this.consumerConfig + '}';
    }

    protected static abstract class Builder<B, SO> {
        String stream;
        boolean bind;
        String durable;
        String name;
        ConsumerConfiguration cc;
        long messageAlarmTime = -1L;
        boolean ordered;
        boolean raiseStatusWarnings = true;

        protected Builder() {
        }

        protected abstract B getThis();

        public B stream(String stream) {
            this.stream = Validator.validateStreamName(stream, false);
            return this.getThis();
        }

        public B bind(boolean bind) {
            this.bind = bind;
            return this.getThis();
        }

        public B durable(String durable) {
            this.durable = Validator.validateDurable(durable, false);
            return this.getThis();
        }

        public B name(String name) {
            this.name = Validator.validateConsumerName(name, false);
            return this.getThis();
        }

        public B configuration(ConsumerConfiguration configuration) {
            this.cc = configuration;
            return this.getThis();
        }

        public B messageAlarmTime(long messageAlarmTime) {
            this.messageAlarmTime = messageAlarmTime;
            return this.getThis();
        }

        public abstract SO build();
    }
}

