/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.Connection;
import io.nats.client.Consumer;
import io.nats.client.ErrorListener;
import io.nats.client.JetStreamSubscription;
import io.nats.client.Message;
import io.nats.client.Subscription;
import io.nats.client.api.ServerInfo;
import io.nats.client.support.Status;
import java.util.logging.Logger;

public class ErrorListenerLoggerImpl
implements ErrorListener {
    private static final Logger LOGGER = Logger.getLogger(ErrorListenerLoggerImpl.class.getName());

    private String supplyMessage(String label, Connection conn, Consumer consumer, Subscription sub, Object ... pairs) {
        ServerInfo si;
        StringBuilder sb = new StringBuilder(label);
        if (conn != null && (si = conn.getServerInfo()) != null) {
            sb.append(", Connection: ").append(conn.getServerInfo().getClientId());
        }
        if (consumer != null) {
            sb.append(", Consumer: ").append(consumer.hashCode());
        }
        if (sub != null) {
            sb.append(", Subscription: ").append(sub.hashCode());
            if (sub instanceof JetStreamSubscription) {
                JetStreamSubscription jssub = (JetStreamSubscription)sub;
                sb.append(", Consumer Name: ").append(jssub.getConsumerName());
            }
        }
        for (int x = 0; x < pairs.length; ++x) {
            sb.append(", ").append(pairs[x]).append(pairs[++x]);
        }
        return sb.toString();
    }

    @Override
    public void errorOccurred(Connection conn, String error) {
        LOGGER.severe(() -> this.supplyMessage("errorOccurred", conn, null, null, "Error: ", error));
    }

    @Override
    public void exceptionOccurred(Connection conn, Exception exp) {
        LOGGER.severe(() -> this.supplyMessage("exceptionOccurred", conn, null, null, "Exception: ", exp));
    }

    @Override
    public void slowConsumerDetected(Connection conn, Consumer consumer) {
        LOGGER.warning(() -> this.supplyMessage("slowConsumerDetected", conn, consumer, null, new Object[0]));
    }

    @Override
    public void messageDiscarded(Connection conn, Message msg) {
        LOGGER.info(() -> this.supplyMessage("messageDiscarded", conn, null, null, "Message: ", msg));
    }

    @Override
    public void heartbeatAlarm(Connection conn, JetStreamSubscription sub, long lastStreamSequence, long lastConsumerSequence) {
        LOGGER.severe(() -> this.supplyMessage("heartbeatAlarm", conn, null, sub, "lastStreamSequence: ", lastStreamSequence, "lastConsumerSequence: ", lastConsumerSequence));
    }

    @Override
    public void unhandledStatus(Connection conn, JetStreamSubscription sub, Status status) {
        LOGGER.warning(() -> this.supplyMessage("unhandledStatus", conn, null, sub, "Status:", status));
    }

    @Override
    public void pullStatusWarning(Connection conn, JetStreamSubscription sub, Status status) {
        LOGGER.warning(() -> this.supplyMessage("pullStatusWarning", conn, null, sub, "Status:", status));
    }

    @Override
    public void pullStatusError(Connection conn, JetStreamSubscription sub, Status status) {
        LOGGER.severe(() -> this.supplyMessage("pullStatusError", conn, null, sub, "Status:", status));
    }

    @Override
    public void flowControlProcessed(Connection conn, JetStreamSubscription sub, String id, ErrorListener.FlowControlSource source) {
        LOGGER.info(() -> this.supplyMessage("flowControlProcessed", conn, null, sub, new Object[]{"FlowControlSource:", source}));
    }
}

