/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.ConsumeOptions;
import io.nats.client.ConsumerContext;
import io.nats.client.Dispatcher;
import io.nats.client.FetchConsumeOptions;
import io.nats.client.FetchConsumer;
import io.nats.client.IterableConsumer;
import io.nats.client.JetStreamApiException;
import io.nats.client.JetStreamStatusCheckedException;
import io.nats.client.JetStreamStatusException;
import io.nats.client.Message;
import io.nats.client.MessageConsumer;
import io.nats.client.MessageHandler;
import io.nats.client.PullRequestOptions;
import io.nats.client.PullSubscribeOptions;
import io.nats.client.api.ConsumerInfo;
import io.nats.client.impl.NatsFetchConsumer;
import io.nats.client.impl.NatsIterableConsumer;
import io.nats.client.impl.NatsJetStream;
import io.nats.client.impl.NatsJetStreamPullSubscription;
import io.nats.client.impl.NatsMessageConsumer;
import io.nats.client.impl.NatsStreamContext;
import io.nats.client.support.Validator;
import java.io.IOException;
import java.time.Duration;

public class NatsConsumerContext
implements ConsumerContext {
    private final NatsStreamContext streamContext;
    private final NatsJetStream js;
    private ConsumerInfo lastConsumerInfo;

    NatsConsumerContext(NatsStreamContext streamContext, ConsumerInfo ci) throws IOException {
        this.streamContext = streamContext;
        this.js = new NatsJetStream(streamContext.jsm.conn, streamContext.jsm.jso);
        this.lastConsumerInfo = ci;
    }

    @Override
    public String getConsumerName() {
        return this.lastConsumerInfo.getName();
    }

    @Override
    public ConsumerInfo getConsumerInfo() throws IOException, JetStreamApiException {
        this.lastConsumerInfo = this.streamContext.jsm.getConsumerInfo(this.streamContext.streamName, this.lastConsumerInfo.getName());
        return this.lastConsumerInfo;
    }

    @Override
    public ConsumerInfo getCachedConsumerInfo() {
        return this.lastConsumerInfo;
    }

    @Override
    public Message next() throws IOException, InterruptedException, JetStreamStatusCheckedException, JetStreamApiException {
        return this.next(30000L);
    }

    @Override
    public Message next(Duration maxWait) throws IOException, InterruptedException, JetStreamStatusCheckedException, JetStreamApiException {
        return this.next(maxWait == null ? 30000L : maxWait.toMillis());
    }

    @Override
    public Message next(long maxWaitMillis) throws IOException, InterruptedException, JetStreamStatusCheckedException, JetStreamApiException {
        if (maxWaitMillis < 1000L) {
            throw new IllegalArgumentException("Max wait must be at least 1000 milliseconds.");
        }
        long expires = maxWaitMillis - 10L;
        NatsJetStreamPullSubscription sub = new SubscriptionMaker().makeSubscription(null);
        sub._pull(PullRequestOptions.builder(1).expiresIn(expires).build(), false, null);
        try {
            return sub.nextMessage(maxWaitMillis);
        }
        catch (JetStreamStatusException e) {
            throw new JetStreamStatusCheckedException(e);
        }
    }

    @Override
    public FetchConsumer fetchMessages(int maxMessages) throws IOException, JetStreamApiException {
        return this.fetch(FetchConsumeOptions.builder().maxMessages(maxMessages).build());
    }

    @Override
    public FetchConsumer fetchBytes(int maxBytes) throws IOException, JetStreamApiException {
        return this.fetch(FetchConsumeOptions.builder().maxBytes(maxBytes).build());
    }

    @Override
    public FetchConsumer fetch(FetchConsumeOptions fetchConsumeOptions) throws IOException, JetStreamApiException {
        Validator.required(fetchConsumeOptions, "Fetch Consume Options");
        return new NatsFetchConsumer(new SubscriptionMaker(), fetchConsumeOptions);
    }

    @Override
    public IterableConsumer consume() throws IOException, JetStreamApiException {
        return new NatsIterableConsumer(new SubscriptionMaker(), ConsumeOptions.DEFAULT_CONSUME_OPTIONS);
    }

    @Override
    public IterableConsumer consume(ConsumeOptions consumeOptions) throws IOException, JetStreamApiException {
        Validator.required(consumeOptions, "Consume Options");
        return new NatsIterableConsumer(new SubscriptionMaker(), consumeOptions);
    }

    @Override
    public MessageConsumer consume(MessageHandler handler) throws IOException, JetStreamApiException {
        Validator.required(handler, "Message Handler");
        return new NatsMessageConsumer(new SubscriptionMaker(), handler, ConsumeOptions.DEFAULT_CONSUME_OPTIONS);
    }

    @Override
    public MessageConsumer consume(MessageHandler handler, ConsumeOptions consumeOptions) throws IOException, JetStreamApiException {
        Validator.required(handler, "Message Handler");
        Validator.required(consumeOptions, "Consume Options");
        return new NatsMessageConsumer(new SubscriptionMaker(), handler, consumeOptions);
    }

    class SubscriptionMaker {
        Dispatcher dispatcher;

        SubscriptionMaker() {
        }

        public NatsJetStreamPullSubscription makeSubscription(MessageHandler messageHandler) throws IOException, JetStreamApiException {
            PullSubscribeOptions pso = PullSubscribeOptions.bind(((NatsConsumerContext)NatsConsumerContext.this).streamContext.streamName, NatsConsumerContext.this.lastConsumerInfo.getName());
            if (messageHandler == null) {
                return (NatsJetStreamPullSubscription)NatsConsumerContext.this.js.subscribe(null, pso);
            }
            this.dispatcher = ((NatsConsumerContext)NatsConsumerContext.this).js.conn.createDispatcher();
            return (NatsJetStreamPullSubscription)NatsConsumerContext.this.js.subscribe(null, this.dispatcher, messageHandler, pso);
        }
    }
}

