/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.FetchConsumeOptions;
import io.nats.client.FetchConsumer;
import io.nats.client.JetStreamApiException;
import io.nats.client.JetStreamStatusCheckedException;
import io.nats.client.JetStreamStatusException;
import io.nats.client.Message;
import io.nats.client.PullRequestOptions;
import io.nats.client.impl.NatsConsumerContext;
import io.nats.client.impl.NatsMessageConsumerBase;
import java.io.IOException;

class NatsFetchConsumer
extends NatsMessageConsumerBase
implements FetchConsumer {
    private final long maxWaitNanos;
    private final String pullSubject;
    private long startNanos;

    public NatsFetchConsumer(NatsConsumerContext.SubscriptionMaker subscriptionMaker, FetchConsumeOptions fetchConsumeOptions) throws IOException, JetStreamApiException {
        this.initSub(subscriptionMaker.makeSubscription(null));
        this.maxWaitNanos = fetchConsumeOptions.getExpiresIn() * 1000000L;
        PullRequestOptions pro = PullRequestOptions.builder(fetchConsumeOptions.getMaxMessages()).maxBytes(fetchConsumeOptions.getMaxBytes()).expiresIn(fetchConsumeOptions.getExpiresIn()).idleHeartbeat(fetchConsumeOptions.getIdleHeartbeat()).build();
        this.pullSubject = this.sub._pull(pro, false, null);
        this.startNanos = -1L;
    }

    @Override
    public Message nextMessage() throws InterruptedException, JetStreamStatusCheckedException {
        try {
            long timeLeftMillis;
            if (this.startNanos == -1L) {
                this.startNanos = System.nanoTime();
            }
            if ((timeLeftMillis = (this.maxWaitNanos - (System.nanoTime() - this.startNanos)) / 1000000L) < 1L | this.pmm.pendingMessages < 1 || this.pmm.trackingBytes && this.pmm.pendingBytes < 1L) {
                return this.sub._nextUnmanagedNoWait(this.pullSubject);
            }
            return this.sub._nextUnmanaged(timeLeftMillis, this.pullSubject);
        }
        catch (JetStreamStatusException e) {
            throw new JetStreamStatusCheckedException(e);
        }
    }
}

