/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import io.nats.client.AuthHandler;
import io.nats.client.ConnectionListener;
import io.nats.client.ErrorListener;
import io.nats.client.Nats;
import io.nats.client.ReconnectDelayHandler;
import io.nats.client.ServerPool;
import io.nats.client.impl.DataPort;
import io.nats.client.impl.ErrorListenerLoggerImpl;
import io.nats.client.impl.SocketDataPort;
import io.nats.client.support.Encoding;
import io.nats.client.support.HttpRequest;
import io.nats.client.support.NatsUri;
import io.nats.client.support.SSLUtils;
import io.nats.client.support.Validator;
import java.io.File;
import java.lang.reflect.Constructor;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.CharBuffer;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import javax.net.ssl.SSLContext;

public class Options {
    public static final String DEFAULT_URL = "nats://localhost:4222";
    public static final int DEFAULT_PORT = 4222;
    public static final int DEFAULT_MAX_RECONNECT = 60;
    public static final Duration DEFAULT_RECONNECT_WAIT = Duration.ofMillis(2000L);
    public static final Duration DEFAULT_RECONNECT_JITTER = Duration.ofMillis(100L);
    public static final Duration DEFAULT_RECONNECT_JITTER_TLS = Duration.ofMillis(1000L);
    public static final Duration DEFAULT_CONNECTION_TIMEOUT = Duration.ofSeconds(2L);
    public static final Duration DEFAULT_PING_INTERVAL = Duration.ofMinutes(2L);
    public static final Duration DEFAULT_REQUEST_CLEANUP_INTERVAL = Duration.ofSeconds(5L);
    public static final int DEFAULT_MAX_PINGS_OUT = 2;
    public static final String DEFAULT_SSL_PROTOCOL = "TLSv1.2";
    public static final int DEFAULT_RECONNECT_BUF_SIZE = 0x800000;
    public static final int DEFAULT_MAX_CONTROL_LINE = 4096;
    public static final String DEFAULT_DATA_PORT_TYPE = SocketDataPort.class.getCanonicalName();
    public static final int DEFAULT_BUFFER_SIZE = 65536;
    public static final String DEFAULT_THREAD_NAME_PREFIX = "nats";
    public static final String DEFAULT_INBOX_PREFIX = "_INBOX.";
    public static final int MAX_MESSAGES_IN_NETWORK_BUFFER = 1000;
    public static final int DEFAULT_MAX_MESSAGES_IN_OUTGOING_QUEUE = 5000;
    public static final boolean DEFAULT_DISCARD_MESSAGES_WHEN_OUTGOING_QUEUE_FULL = false;
    static final String PFX = "io.nats.client.";
    static final int PFX_LEN = "io.nats.client.".length();
    public static final String PROP_CONNECTION_CB = "io.nats.client.callback.connection";
    public static final String PROP_DATA_PORT_TYPE = "io.nats.client.dataport.type";
    public static final String PROP_ERROR_LISTENER = "io.nats.client.callback.error";
    public static final String PROP_MAX_PINGS = "io.nats.client.maxpings";
    public static final String PROP_PING_INTERVAL = "io.nats.client.pinginterval";
    public static final String PROP_CLEANUP_INTERVAL = "io.nats.client.cleanupinterval";
    public static final String PROP_CONNECTION_TIMEOUT = "io.nats.client.timeout";
    public static final String PROP_RECONNECT_BUF_SIZE = "io.nats.client.reconnect.buffer.size";
    public static final String PROP_RECONNECT_WAIT = "io.nats.client.reconnect.wait";
    public static final String PROP_MAX_RECONNECT = "io.nats.client.reconnect.max";
    public static final String PROP_RECONNECT_JITTER = "io.nats.client.reconnect.jitter";
    public static final String PROP_RECONNECT_JITTER_TLS = "io.nats.client.reconnect.jitter.tls";
    public static final String PROP_PEDANTIC = "io.nats.client.pedantic";
    public static final String PROP_VERBOSE = "io.nats.client.verbose";
    public static final String PROP_NO_ECHO = "io.nats.client.noecho";
    public static final String PROP_NO_HEADERS = "io.nats.client.noheaders";
    public static final String PROP_CONNECTION_NAME = "io.nats.client.name";
    public static final String PROP_NO_NORESPONDERS = "io.nats.client.nonoresponders";
    public static final String PROP_NORANDOMIZE = "io.nats.client.norandomize";
    public static final String PROP_NO_RESOLVE_HOSTNAMES = "io.nats.client.noResolveHostnames";
    public static final String PROP_REPORT_NO_RESPONDERS = "io.nats.client.reportNoResponders";
    public static final String PROP_SERVERS = "io.nats.client.servers";
    public static final String PROP_PASSWORD = "io.nats.client.password";
    public static final String PROP_USERNAME = "io.nats.client.username";
    public static final String PROP_TOKEN = "io.nats.client.token";
    public static final String PROP_URL = "io.nats.client.url";
    public static final String PROP_SECURE = "io.nats.client.secure";
    public static final String PROP_OPENTLS = "io.nats.client.opentls";
    public static final String PROP_MAX_MESSAGES_IN_OUTGOING_QUEUE = "io.nats.client.outgoingqueue.maxmessages";
    public static final String PROP_DISCARD_MESSAGES_WHEN_OUTGOING_QUEUE_FULL = "io.nats.client.outgoingqueue.discardwhenfull";
    public static final String PROP_USE_OLD_REQUEST_STYLE = "use.old.request.style";
    public static final String PROP_MAX_CONTROL_LINE = "max.control.line";
    public static final String PROP_INBOX_PREFIX = "inbox.prefix";
    public static final String PROP_IGNORE_DISCOVERED_SERVERS = "ignore_discovered_servers";
    public static final String PROP_IGNORE_DISCOVERED_SERVERS_PREFERRED = "ignore.discovered.servers";
    public static final String PROP_SERVERS_POOL_IMPLEMENTATION_CLASS = "servers_pool_implementation_class";
    public static final String PROP_SERVERS_POOL_IMPLEMENTATION_CLASS_PREFERRED = "servers.pool.implementation.class";
    public static final String PROP_KEYSTORE = "io.nats.client.keyStore";
    public static final String PROP_KEYSTORE_PASSWORD = "io.nats.client.keyStorePassword";
    public static final String PROP_TRUSTSTORE = "io.nats.client.trustStore";
    public static final String PROP_TRUSTSTORE_PASSWORD = "io.nats.client.trustStorePassword";
    public static final String PROP_TLS_ALGORITHM = "io.nats.client.tls.algorithm";
    public static final String PROP_CREDENTIAL_PATH = "io.nats.client.credential.path";
    @Deprecated
    public static final String PROP_CLIENT_SIDE_LIMIT_CHECKS = "io.nats.client.clientsidelimitchecks";
    @Deprecated
    public static final String PROP_UTF8_SUBJECTS = "allow.utf8.subjects";
    static final String OPTION_VERBOSE = "verbose";
    static final String OPTION_PEDANTIC = "pedantic";
    static final String OPTION_TLS_REQUIRED = "tls_required";
    static final String OPTION_AUTH_TOKEN = "auth_token";
    static final String OPTION_USER = "user";
    static final String OPTION_PASSWORD = "pass";
    static final String OPTION_NAME = "name";
    static final String OPTION_LANG = "lang";
    static final String OPTION_VERSION = "version";
    static final String OPTION_PROTOCOL = "protocol";
    static final String OPTION_ECHO = "echo";
    static final String OPTION_NKEY = "nkey";
    static final String OPTION_SIG = "sig";
    static final String OPTION_JWT = "jwt";
    static final String OPTION_HEADERS = "headers";
    static final String OPTION_NORESPONDERS = "no_responders";
    private final List<NatsUri> natsServerUris;
    private final List<String> unprocessedServers;
    private final boolean noRandomize;
    private final boolean noResolveHostnames;
    private final boolean reportNoResponders;
    private final String connectionName;
    private final boolean verbose;
    private final boolean pedantic;
    private final SSLContext sslContext;
    private final int maxReconnect;
    private final int maxControlLine;
    private final Duration reconnectWait;
    private final Duration reconnectJitter;
    private final Duration reconnectJitterTls;
    private final Duration connectionTimeout;
    private final Duration pingInterval;
    private final Duration requestCleanupInterval;
    private final int maxPingsOut;
    private final long reconnectBufferSize;
    private final char[] username;
    private final char[] password;
    private final char[] token;
    private final String inboxPrefix;
    private boolean useOldRequestStyle;
    private final int bufferSize;
    private final boolean noEcho;
    private final boolean noHeaders;
    private final boolean noNoResponders;
    private final int maxMessagesInOutgoingQueue;
    private final boolean discardMessagesWhenOutgoingQueueFull;
    private final boolean ignoreDiscoveredServers;
    private final AuthHandler authHandler;
    private final ReconnectDelayHandler reconnectDelayHandler;
    private final ErrorListener errorListener;
    private final ConnectionListener connectionListener;
    private final String dataPortType;
    private final boolean trackAdvancedStats;
    private final boolean traceConnection;
    private final ExecutorService executor;
    private final ServerPool serverPool;
    private final List<Consumer<HttpRequest>> httpRequestInterceptors;
    private final Proxy proxy;

    @Deprecated
    public void setOldRequestStyle(boolean value) {
        this.useOldRequestStyle = value;
    }

    public static Builder builder() {
        return new Builder();
    }

    private Options(Builder b) {
        this.natsServerUris = b.natsServerUris.size() == 0 ? Collections.singletonList(NatsUri.DEFAULT_NATS_URI) : Collections.unmodifiableList(b.natsServerUris);
        this.unprocessedServers = b.unprocessedServers;
        this.noRandomize = b.noRandomize;
        this.noResolveHostnames = b.noResolveHostnames;
        this.reportNoResponders = b.reportNoResponders;
        this.connectionName = b.connectionName;
        this.verbose = b.verbose;
        this.pedantic = b.pedantic;
        this.sslContext = b.sslContext;
        this.maxReconnect = b.maxReconnect;
        this.reconnectWait = b.reconnectWait;
        this.reconnectJitter = b.reconnectJitter;
        this.reconnectJitterTls = b.reconnectJitterTls;
        this.connectionTimeout = b.connectionTimeout;
        this.pingInterval = b.pingInterval;
        this.requestCleanupInterval = b.requestCleanupInterval;
        this.maxPingsOut = b.maxPingsOut;
        this.reconnectBufferSize = b.reconnectBufferSize;
        this.username = b.username;
        this.password = b.password;
        this.token = b.token;
        this.useOldRequestStyle = b.useOldRequestStyle;
        this.maxControlLine = b.maxControlLine;
        this.bufferSize = b.bufferSize;
        this.noEcho = b.noEcho;
        this.noHeaders = b.noHeaders;
        this.noNoResponders = b.noNoResponders;
        this.inboxPrefix = b.inboxPrefix;
        this.traceConnection = b.traceConnection;
        this.maxMessagesInOutgoingQueue = b.maxMessagesInOutgoingQueue;
        this.discardMessagesWhenOutgoingQueueFull = b.discardMessagesWhenOutgoingQueueFull;
        this.authHandler = b.authHandler;
        this.reconnectDelayHandler = b.reconnectDelayHandler;
        this.errorListener = b.errorListener == null ? new ErrorListenerLoggerImpl() : b.errorListener;
        this.connectionListener = b.connectionListener;
        this.dataPortType = b.dataPortType;
        this.trackAdvancedStats = b.trackAdvancedStats;
        this.executor = b.executor;
        this.httpRequestInterceptors = b.httpRequestInterceptors;
        this.proxy = b.proxy;
        this.ignoreDiscoveredServers = b.ignoreDiscoveredServers;
        this.serverPool = b.serverPool;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public List<Consumer<HttpRequest>> getHttpRequestInterceptors() {
        return null == this.httpRequestInterceptors ? Collections.emptyList() : Collections.unmodifiableList(this.httpRequestInterceptors);
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public ErrorListener getErrorListener() {
        return this.errorListener;
    }

    public ConnectionListener getConnectionListener() {
        return this.connectionListener;
    }

    public AuthHandler getAuthHandler() {
        return this.authHandler;
    }

    public ReconnectDelayHandler getReconnectDelayHandler() {
        return this.reconnectDelayHandler;
    }

    public String getDataPortType() {
        return this.dataPortType;
    }

    public DataPort buildDataPort() {
        return (DataPort)Options.createInstanceOf(this.dataPortType);
    }

    public List<URI> getServers() {
        ArrayList<URI> list = new ArrayList<URI>();
        for (NatsUri nuri : this.natsServerUris) {
            list.add(nuri.getUri());
        }
        return list;
    }

    public List<NatsUri> getNatsServerUris() {
        return this.natsServerUris;
    }

    public List<String> getUnprocessedServers() {
        return this.unprocessedServers;
    }

    public boolean isNoRandomize() {
        return this.noRandomize;
    }

    public boolean isNoResolveHostnames() {
        return this.noResolveHostnames;
    }

    public boolean isReportNoResponders() {
        return this.reportNoResponders;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isNoEcho() {
        return this.noEcho;
    }

    public boolean isNoHeaders() {
        return this.noHeaders;
    }

    public boolean isNoNoResponders() {
        return this.noNoResponders;
    }

    @Deprecated
    public boolean clientSideLimitChecks() {
        return false;
    }

    @Deprecated
    public boolean supportUTF8Subjects() {
        return false;
    }

    public boolean isPedantic() {
        return this.pedantic;
    }

    public boolean isTrackAdvancedStats() {
        return this.trackAdvancedStats;
    }

    public boolean isTraceConnection() {
        return this.traceConnection;
    }

    public int getMaxControlLine() {
        return this.maxControlLine;
    }

    public boolean isTLSRequired() {
        return this.sslContext != null;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public int getMaxReconnect() {
        return this.maxReconnect;
    }

    public Duration getReconnectWait() {
        return this.reconnectWait;
    }

    public Duration getReconnectJitter() {
        return this.reconnectJitter;
    }

    public Duration getReconnectJitterTls() {
        return this.reconnectJitterTls;
    }

    public Duration getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public Duration getPingInterval() {
        return this.pingInterval;
    }

    public Duration getRequestCleanupInterval() {
        return this.requestCleanupInterval;
    }

    public int getMaxPingsOut() {
        return this.maxPingsOut;
    }

    public long getReconnectBufferSize() {
        return this.reconnectBufferSize;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    @Deprecated
    public String getUsername() {
        return this.username == null ? null : new String(this.username);
    }

    public char[] getUsernameChars() {
        return this.username;
    }

    @Deprecated
    public String getPassword() {
        return this.password == null ? null : new String(this.password);
    }

    public char[] getPasswordChars() {
        return this.password;
    }

    @Deprecated
    public String getToken() {
        return this.token == null ? null : new String(this.token);
    }

    public char[] getTokenChars() {
        return this.token;
    }

    public boolean isOldRequestStyle() {
        return this.useOldRequestStyle;
    }

    public String getInboxPrefix() {
        return this.inboxPrefix;
    }

    public int getMaxMessagesInOutgoingQueue() {
        return this.maxMessagesInOutgoingQueue;
    }

    public boolean isDiscardMessagesWhenOutgoingQueueFull() {
        return this.discardMessagesWhenOutgoingQueueFull;
    }

    public boolean isIgnoreDiscoveredServers() {
        return this.ignoreDiscoveredServers;
    }

    public ServerPool getServerPool() {
        return this.serverPool;
    }

    public URI createURIForServer(String serverURI) throws URISyntaxException {
        return new NatsUri(serverURI).getUri();
    }

    public CharBuffer buildProtocolConnectOptionsString(String serverURI, boolean includeAuth, byte[] nonce) {
        CharBuffer connectString = CharBuffer.allocate(this.maxControlLine);
        connectString.append("{");
        Options.appendOption(connectString, OPTION_LANG, "java", true, false);
        Options.appendOption(connectString, OPTION_VERSION, Nats.CLIENT_VERSION, true, true);
        if (this.connectionName != null) {
            Options.appendOption(connectString, OPTION_NAME, this.connectionName, true, true);
        }
        Options.appendOption(connectString, OPTION_PROTOCOL, "1", false, true);
        Options.appendOption(connectString, OPTION_VERBOSE, String.valueOf(this.isVerbose()), false, true);
        Options.appendOption(connectString, OPTION_PEDANTIC, String.valueOf(this.isPedantic()), false, true);
        Options.appendOption(connectString, OPTION_TLS_REQUIRED, String.valueOf(this.isTLSRequired()), false, true);
        Options.appendOption(connectString, OPTION_ECHO, String.valueOf(!this.isNoEcho()), false, true);
        Options.appendOption(connectString, OPTION_HEADERS, String.valueOf(!this.isNoHeaders()), false, true);
        Options.appendOption(connectString, OPTION_NORESPONDERS, String.valueOf(!this.isNoNoResponders()), false, true);
        if (includeAuth && nonce != null && this.getAuthHandler() != null) {
            char[] nkey = this.getAuthHandler().getID();
            byte[] sig = this.getAuthHandler().sign(nonce);
            char[] jwt = this.getAuthHandler().getJWT();
            if (sig == null) {
                sig = new byte[]{};
            }
            if (jwt == null) {
                jwt = new char[]{};
            }
            if (nkey == null) {
                nkey = new char[]{};
            }
            String encodedSig = Base64.getUrlEncoder().withoutPadding().encodeToString(sig);
            Options.appendOption(connectString, OPTION_NKEY, nkey, true, true);
            Options.appendOption(connectString, OPTION_SIG, encodedSig, true, true);
            Options.appendOption(connectString, OPTION_JWT, jwt, true, true);
        } else if (includeAuth) {
            String uriUser = null;
            String uriPass = null;
            String uriToken = null;
            try {
                URI uri = this.createURIForServer(serverURI);
                String userInfo = uri.getRawUserInfo();
                if (userInfo != null) {
                    int at = userInfo.indexOf(":");
                    if (at == -1) {
                        uriToken = Encoding.uriDecode(userInfo);
                    } else {
                        uriUser = Encoding.uriDecode(userInfo.substring(0, at));
                        uriPass = Encoding.uriDecode(userInfo.substring(at + 1));
                    }
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            if (uriUser != null) {
                Options.appendOption(connectString, OPTION_USER, uriUser, true, true);
            } else if (this.username != null) {
                Options.appendOption(connectString, OPTION_USER, this.username, true, true);
            }
            if (uriPass != null) {
                Options.appendOption(connectString, OPTION_PASSWORD, uriPass, true, true);
            } else if (this.password != null) {
                Options.appendOption(connectString, OPTION_PASSWORD, this.password, true, true);
            }
            if (uriToken != null) {
                Options.appendOption(connectString, OPTION_AUTH_TOKEN, uriToken, true, true);
            } else if (this.token != null) {
                Options.appendOption(connectString, OPTION_AUTH_TOKEN, this.token, true, true);
            }
        }
        connectString.append("}");
        connectString.flip();
        return connectString;
    }

    private static void appendOption(CharBuffer builder, String key, String value, boolean quotes, boolean comma) {
        Options._appendStart(builder, key, quotes, comma);
        builder.append(value);
        Options._appendOptionEnd(builder, quotes);
    }

    private static void appendOption(CharBuffer builder, String key, char[] value, boolean quotes, boolean comma) {
        Options._appendStart(builder, key, quotes, comma);
        builder.put(value);
        Options._appendOptionEnd(builder, quotes);
    }

    private static void _appendStart(CharBuffer builder, String key, boolean quotes, boolean comma) {
        if (comma) {
            builder.append(',');
        }
        builder.append('\"');
        builder.append(key);
        builder.append('\"');
        builder.append(':');
        Options._appendOptionEnd(builder, quotes);
    }

    private static void _appendOptionEnd(CharBuffer builder, boolean quotes) {
        if (quotes) {
            builder.append('\"');
        }
    }

    private static String getPropertyValue(Properties props, String key) {
        String value = Validator.emptyAsNull(props.getProperty(key));
        if (value != null) {
            return value;
        }
        if (key.startsWith(PFX)) {
            return Validator.emptyAsNull(props.getProperty(key.substring(PFX_LEN)));
        }
        value = Validator.emptyAsNull(props.getProperty(PFX + key));
        if (value == null && key.contains("_")) {
            return Options.getPropertyValue(props, key.replace("_", "."));
        }
        return value;
    }

    private static void stringProperty(Properties props, String key, Consumer<String> consumer) {
        String value = Options.getPropertyValue(props, key);
        if (value != null) {
            consumer.accept(value);
        }
    }

    private static void charArrayProperty(Properties props, String key, Consumer<char[]> consumer) {
        String value = Options.getPropertyValue(props, key);
        if (value != null) {
            consumer.accept(value.toCharArray());
        }
    }

    private static void booleanProperty(Properties props, String key, Consumer<Boolean> consumer) {
        String value = Options.getPropertyValue(props, key);
        if (value != null) {
            consumer.accept(Boolean.parseBoolean(value));
        }
    }

    private static void intProperty(Properties props, String key, int defaultValue, Consumer<Integer> consumer) {
        String value = Options.getPropertyValue(props, key);
        if (value == null) {
            consumer.accept(defaultValue);
        } else {
            consumer.accept(Integer.parseInt(value));
        }
    }

    private static void intGtEqZeroProperty(Properties props, String key, int defaultValue, Consumer<Integer> consumer) {
        String value = Options.getPropertyValue(props, key);
        if (value == null) {
            consumer.accept(defaultValue);
        } else {
            int i = Integer.parseInt(value);
            if (i < 0) {
                consumer.accept(defaultValue);
            } else {
                consumer.accept(i);
            }
        }
    }

    private static void longProperty(Properties props, String key, long defaultValue, Consumer<Long> consumer) {
        String value = Options.getPropertyValue(props, key);
        if (value == null) {
            consumer.accept(defaultValue);
        } else {
            consumer.accept(Long.parseLong(value));
        }
    }

    private static void durationProperty(Properties props, String key, Duration defaultValue, Consumer<Duration> consumer) {
        String value = Options.getPropertyValue(props, key);
        if (value == null) {
            consumer.accept(defaultValue);
        } else {
            int ms = Integer.parseInt(value);
            if (ms < 0) {
                consumer.accept(defaultValue);
            } else {
                consumer.accept(Duration.ofMillis(ms));
            }
        }
    }

    private static void classnameProperty(Properties props, String key, Consumer<Object> consumer) {
        Options.stringProperty(props, key, className -> consumer.accept(Options.createInstanceOf(className)));
    }

    private static Object createInstanceOf(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static class Builder {
        private final List<NatsUri> natsServerUris = new ArrayList<NatsUri>();
        private final List<String> unprocessedServers = new ArrayList<String>();
        private boolean noRandomize = false;
        private boolean noResolveHostnames = false;
        private boolean reportNoResponders = false;
        private String connectionName = null;
        private boolean verbose = false;
        private boolean pedantic = false;
        private SSLContext sslContext = null;
        private int maxControlLine = 4096;
        private int maxReconnect = 60;
        private Duration reconnectWait = DEFAULT_RECONNECT_WAIT;
        private Duration reconnectJitter = DEFAULT_RECONNECT_JITTER;
        private Duration reconnectJitterTls = DEFAULT_RECONNECT_JITTER_TLS;
        private Duration connectionTimeout = DEFAULT_CONNECTION_TIMEOUT;
        private Duration pingInterval = DEFAULT_PING_INTERVAL;
        private Duration requestCleanupInterval = DEFAULT_REQUEST_CLEANUP_INTERVAL;
        private int maxPingsOut = 2;
        private long reconnectBufferSize = 0x800000L;
        private char[] username = null;
        private char[] password = null;
        private char[] token = null;
        private boolean useOldRequestStyle = false;
        private int bufferSize = 65536;
        private boolean trackAdvancedStats = false;
        private boolean traceConnection = false;
        private boolean noEcho = false;
        private boolean noHeaders = false;
        private boolean noNoResponders = false;
        private String inboxPrefix = "_INBOX.";
        private int maxMessagesInOutgoingQueue = 5000;
        private boolean discardMessagesWhenOutgoingQueueFull = false;
        private boolean ignoreDiscoveredServers = false;
        private ServerPool serverPool = null;
        private AuthHandler authHandler;
        private ReconnectDelayHandler reconnectDelayHandler;
        private ErrorListener errorListener = null;
        private ConnectionListener connectionListener = null;
        private String dataPortType = DEFAULT_DATA_PORT_TYPE;
        private ExecutorService executor;
        private List<Consumer<HttpRequest>> httpRequestInterceptors;
        private Proxy proxy;
        private boolean useDefaultTls;
        private boolean useTrustAllTls;
        private String keystore;
        private char[] keystorePassword;
        private String truststore;
        private char[] truststorePassword;
        private String tlsAlgorithm = "SunX509";
        private String credentialPath;

        public Builder() {
        }

        public Builder(Properties props) throws IllegalArgumentException {
            this.properties(props);
        }

        public Builder properties(Properties props) {
            if (props == null) {
                throw new IllegalArgumentException("Properties cannot be null");
            }
            Options.stringProperty(props, Options.PROP_URL, this::server);
            Options.stringProperty(props, Options.PROP_SERVERS, str -> {
                String[] servers = str.trim().split(",\\s*");
                this.servers(servers);
            });
            Options.charArrayProperty(props, Options.PROP_USERNAME, ca -> {
                this.username = ca;
            });
            Options.charArrayProperty(props, Options.PROP_PASSWORD, ca -> {
                this.password = ca;
            });
            Options.charArrayProperty(props, Options.PROP_TOKEN, ca -> {
                this.token = ca;
            });
            Options.booleanProperty(props, Options.PROP_SECURE, b -> {
                this.useDefaultTls = b;
            });
            Options.booleanProperty(props, Options.PROP_OPENTLS, b -> {
                this.useTrustAllTls = b;
            });
            Options.stringProperty(props, Options.PROP_KEYSTORE, s -> {
                this.keystore = s;
            });
            Options.charArrayProperty(props, Options.PROP_KEYSTORE_PASSWORD, ca -> {
                this.keystorePassword = ca;
            });
            Options.stringProperty(props, Options.PROP_TRUSTSTORE, s -> {
                this.truststore = s;
            });
            Options.charArrayProperty(props, Options.PROP_TRUSTSTORE_PASSWORD, ca -> {
                this.truststorePassword = ca;
            });
            Options.stringProperty(props, Options.PROP_TLS_ALGORITHM, s -> {
                this.tlsAlgorithm = s;
            });
            Options.stringProperty(props, Options.PROP_CREDENTIAL_PATH, s -> {
                this.credentialPath = s;
            });
            Options.stringProperty(props, Options.PROP_CONNECTION_NAME, s -> {
                this.connectionName = s;
            });
            Options.booleanProperty(props, Options.PROP_NORANDOMIZE, b -> {
                this.noRandomize = b;
            });
            Options.booleanProperty(props, Options.PROP_NO_RESOLVE_HOSTNAMES, b -> {
                this.noResolveHostnames = b;
            });
            Options.booleanProperty(props, Options.PROP_REPORT_NO_RESPONDERS, b -> {
                this.reportNoResponders = b;
            });
            Options.stringProperty(props, Options.PROP_CONNECTION_NAME, s -> {
                this.connectionName = s;
            });
            Options.booleanProperty(props, Options.PROP_VERBOSE, b -> {
                this.verbose = b;
            });
            Options.booleanProperty(props, Options.PROP_NO_ECHO, b -> {
                this.noEcho = b;
            });
            Options.booleanProperty(props, Options.PROP_NO_HEADERS, b -> {
                this.noHeaders = b;
            });
            Options.booleanProperty(props, Options.PROP_NO_NORESPONDERS, b -> {
                this.noNoResponders = b;
            });
            Options.booleanProperty(props, Options.PROP_PEDANTIC, b -> {
                this.pedantic = b;
            });
            Options.intProperty(props, Options.PROP_MAX_RECONNECT, 60, i -> {
                this.maxReconnect = i;
            });
            Options.durationProperty(props, Options.PROP_RECONNECT_WAIT, DEFAULT_RECONNECT_WAIT, d -> {
                this.reconnectWait = d;
            });
            Options.durationProperty(props, Options.PROP_RECONNECT_JITTER, DEFAULT_RECONNECT_JITTER, d -> {
                this.reconnectJitter = d;
            });
            Options.durationProperty(props, Options.PROP_RECONNECT_JITTER_TLS, DEFAULT_RECONNECT_JITTER_TLS, d -> {
                this.reconnectJitterTls = d;
            });
            Options.longProperty(props, Options.PROP_RECONNECT_BUF_SIZE, 0x800000L, l -> {
                this.reconnectBufferSize = l;
            });
            Options.durationProperty(props, Options.PROP_CONNECTION_TIMEOUT, DEFAULT_CONNECTION_TIMEOUT, d -> {
                this.connectionTimeout = d;
            });
            Options.intGtEqZeroProperty(props, Options.PROP_MAX_CONTROL_LINE, 4096, i -> {
                this.maxControlLine = i;
            });
            Options.durationProperty(props, Options.PROP_PING_INTERVAL, DEFAULT_PING_INTERVAL, d -> {
                this.pingInterval = d;
            });
            Options.durationProperty(props, Options.PROP_CLEANUP_INTERVAL, DEFAULT_REQUEST_CLEANUP_INTERVAL, d -> {
                this.requestCleanupInterval = d;
            });
            Options.intProperty(props, Options.PROP_MAX_PINGS, 2, i -> {
                this.maxPingsOut = i;
            });
            Options.booleanProperty(props, Options.PROP_USE_OLD_REQUEST_STYLE, b -> {
                this.useOldRequestStyle = b;
            });
            Options.classnameProperty(props, Options.PROP_ERROR_LISTENER, o -> {
                this.errorListener = (ErrorListener)o;
            });
            Options.classnameProperty(props, Options.PROP_CONNECTION_CB, o -> {
                this.connectionListener = (ConnectionListener)o;
            });
            Options.stringProperty(props, Options.PROP_DATA_PORT_TYPE, s -> {
                this.dataPortType = s;
            });
            Options.stringProperty(props, Options.PROP_INBOX_PREFIX, this::inboxPrefix);
            Options.intGtEqZeroProperty(props, Options.PROP_MAX_MESSAGES_IN_OUTGOING_QUEUE, 5000, i -> {
                this.maxMessagesInOutgoingQueue = i;
            });
            Options.booleanProperty(props, Options.PROP_DISCARD_MESSAGES_WHEN_OUTGOING_QUEUE_FULL, b -> {
                this.discardMessagesWhenOutgoingQueueFull = b;
            });
            Options.booleanProperty(props, Options.PROP_IGNORE_DISCOVERED_SERVERS, b -> {
                this.ignoreDiscoveredServers = b;
            });
            Options.classnameProperty(props, Options.PROP_SERVERS_POOL_IMPLEMENTATION_CLASS, o -> {
                this.serverPool = (ServerPool)o;
            });
            return this;
        }

        public Builder server(String serverURL) {
            return this.servers(serverURL.trim().split(","));
        }

        public Builder servers(String[] servers) {
            for (String s : servers) {
                if (s == null || s.isEmpty()) continue;
                try {
                    String unprocessed = s.trim();
                    NatsUri nuri = new NatsUri(unprocessed);
                    if (this.natsServerUris.contains(nuri)) continue;
                    this.natsServerUris.add(nuri);
                    this.unprocessedServers.add(unprocessed);
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            return this;
        }

        public Builder oldRequestStyle() {
            this.useOldRequestStyle = true;
            return this;
        }

        public Builder noRandomize() {
            this.noRandomize = true;
            return this;
        }

        public Builder noResolveHostnames() {
            this.noResolveHostnames = true;
            return this;
        }

        public Builder reportNoResponders() {
            this.reportNoResponders = true;
            return this;
        }

        public Builder noEcho() {
            this.noEcho = true;
            return this;
        }

        public Builder noHeaders() {
            this.noHeaders = true;
            return this;
        }

        public Builder noNoResponders() {
            this.noNoResponders = true;
            return this;
        }

        @Deprecated
        public Builder clientSideLimitChecks(boolean checks) {
            return this;
        }

        @Deprecated
        public Builder supportUTF8Subjects() {
            return this;
        }

        public Builder connectionName(String name) {
            this.connectionName = name;
            return this;
        }

        public Builder inboxPrefix(String prefix) {
            this.inboxPrefix = prefix;
            if (!this.inboxPrefix.endsWith(".")) {
                this.inboxPrefix = this.inboxPrefix + ".";
            }
            return this;
        }

        public Builder verbose() {
            this.verbose = true;
            return this;
        }

        public Builder pedantic() {
            this.pedantic = true;
            return this;
        }

        public Builder turnOnAdvancedStats() {
            this.trackAdvancedStats = true;
            return this;
        }

        public Builder traceConnection() {
            this.traceConnection = true;
            return this;
        }

        public Builder secure() throws NoSuchAlgorithmException {
            this.useDefaultTls = true;
            return this;
        }

        public Builder opentls() throws NoSuchAlgorithmException {
            this.useTrustAllTls = true;
            return this;
        }

        public Builder sslContext(SSLContext ctx) {
            this.sslContext = ctx;
            return this;
        }

        public Builder keystorePath(String keystore) {
            this.keystore = Validator.emptyAsNull(keystore);
            return this;
        }

        public Builder keystorePassword(char[] keystorePassword) {
            this.keystorePassword = keystorePassword == null || keystorePassword.length == 0 ? null : keystorePassword;
            return this;
        }

        public Builder truststorePath(String truststore) {
            this.truststore = Validator.emptyAsNull(truststore);
            return this;
        }

        public Builder truststorePassword(char[] truststorePassword) {
            this.truststorePassword = truststorePassword == null || truststorePassword.length == 0 ? null : truststorePassword;
            return this;
        }

        public Builder tlsAlgorithm(String tlsAlgorithm) {
            this.tlsAlgorithm = Validator.emptyOrNullAs(tlsAlgorithm, "SunX509");
            return this;
        }

        public Builder credentialPath(String credentialPath) {
            this.credentialPath = Validator.emptyAsNull(credentialPath);
            return this;
        }

        public Builder noReconnect() {
            this.maxReconnect = 0;
            return this;
        }

        public Builder maxReconnects(int max) {
            this.maxReconnect = max;
            return this;
        }

        public Builder reconnectWait(Duration time) {
            this.reconnectWait = time;
            return this;
        }

        public Builder reconnectJitter(Duration time) {
            this.reconnectJitter = time;
            return this;
        }

        public Builder reconnectJitterTls(Duration time) {
            this.reconnectJitterTls = time;
            return this;
        }

        public Builder maxControlLine(int bytes) {
            this.maxControlLine = bytes < 0 ? 4096 : bytes;
            return this;
        }

        public Builder connectionTimeout(Duration time) {
            this.connectionTimeout = time;
            return this;
        }

        public Builder pingInterval(Duration time) {
            this.pingInterval = time;
            return this;
        }

        public Builder requestCleanupInterval(Duration time) {
            this.requestCleanupInterval = time;
            return this;
        }

        public Builder maxPingsOut(int max) {
            this.maxPingsOut = max;
            return this;
        }

        public Builder bufferSize(int size) {
            this.bufferSize = size;
            return this;
        }

        public Builder reconnectBufferSize(long size) {
            this.reconnectBufferSize = size;
            return this;
        }

        public Builder userInfo(String userName, String password) {
            this.username = userName.toCharArray();
            this.password = password.toCharArray();
            return this;
        }

        public Builder userInfo(char[] userName, char[] password) {
            this.username = userName;
            this.password = password;
            return this;
        }

        @Deprecated
        public Builder token(String token) {
            this.token = token.toCharArray();
            return this;
        }

        public Builder token(char[] token) {
            this.token = token;
            return this;
        }

        public Builder authHandler(AuthHandler handler) {
            this.authHandler = handler;
            return this;
        }

        public Builder reconnectDelayHandler(ReconnectDelayHandler handler) {
            this.reconnectDelayHandler = handler;
            return this;
        }

        public Builder errorListener(ErrorListener listener) {
            this.errorListener = listener;
            return this;
        }

        public Builder connectionListener(ConnectionListener listener) {
            this.connectionListener = listener;
            return this;
        }

        public Builder executor(ExecutorService executor) {
            this.executor = executor;
            return this;
        }

        public Builder httpRequestInterceptor(Consumer<HttpRequest> interceptor) {
            if (null == this.httpRequestInterceptors) {
                this.httpRequestInterceptors = new ArrayList<Consumer<HttpRequest>>();
            }
            this.httpRequestInterceptors.add(interceptor);
            return this;
        }

        public Builder httpRequestInterceptors(Collection<? extends Consumer<HttpRequest>> interceptors) {
            this.httpRequestInterceptors = new ArrayList<Consumer<HttpRequest>>(interceptors);
            return this;
        }

        public Builder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder dataPortType(String dataPortClassName) {
            this.dataPortType = dataPortClassName;
            return this;
        }

        public Builder maxMessagesInOutgoingQueue(int maxMessagesInOutgoingQueue) {
            this.maxMessagesInOutgoingQueue = maxMessagesInOutgoingQueue < 0 ? 5000 : maxMessagesInOutgoingQueue;
            return this;
        }

        public Builder discardMessagesWhenOutgoingQueueFull() {
            this.discardMessagesWhenOutgoingQueueFull = true;
            return this;
        }

        public Builder ignoreDiscoveredServers() {
            this.ignoreDiscoveredServers = true;
            return this;
        }

        public Builder serverPool(ServerPool serverPool) {
            this.serverPool = serverPool;
            return this;
        }

        public Options build() throws IllegalStateException {
            if (this.username != null && this.token != null) {
                throw new IllegalStateException("Options can't have token and username");
            }
            if (this.inboxPrefix == null) {
                this.inboxPrefix = Options.DEFAULT_INBOX_PREFIX;
            }
            boolean checkUrisForSecure = true;
            if (this.natsServerUris.size() == 0) {
                this.server(Options.DEFAULT_URL);
                checkUrisForSecure = false;
            }
            if (this.sslContext == null) {
                if (this.keystore != null) {
                    try {
                        this.sslContext = SSLUtils.createSSLContext(this.keystore, this.keystorePassword, this.truststore, this.truststorePassword, this.tlsAlgorithm);
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("Unable to create SSL context", e);
                    }
                }
                if (!this.useDefaultTls && !this.useTrustAllTls && checkUrisForSecure) {
                    block15: for (int i = 0; this.sslContext == null && i < this.natsServerUris.size(); ++i) {
                        NatsUri natsUri = this.natsServerUris.get(i);
                        switch (natsUri.getScheme()) {
                            case "tls": 
                            case "wss": {
                                this.useDefaultTls = true;
                                continue block15;
                            }
                            case "opentls": {
                                this.useTrustAllTls = true;
                            }
                        }
                    }
                }
                if (this.useTrustAllTls) {
                    try {
                        this.sslContext = SSLUtils.createTrustAllTlsContext();
                    }
                    catch (GeneralSecurityException e) {
                        throw new IllegalStateException("Unable to create SSL context", e);
                    }
                }
                if (this.useDefaultTls) {
                    try {
                        this.sslContext = SSLContext.getDefault();
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new IllegalStateException("Unable to create default SSL context", e);
                    }
                }
            }
            if (this.credentialPath != null) {
                File file = new File(this.credentialPath).getAbsoluteFile();
                this.authHandler = Nats.credentials(file.toString());
            }
            if (this.executor == null) {
                String threadPrefix = this.connectionName != null && this.connectionName.length() > 0 ? this.connectionName : Options.DEFAULT_THREAD_NAME_PREFIX;
                this.executor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 500L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), new DefaultThreadFactory(threadPrefix));
            }
            return new Options(this);
        }

        public Builder(Options o) {
            if (o == null) {
                throw new IllegalArgumentException("Options cannot be null");
            }
            this.natsServerUris.addAll(o.natsServerUris);
            this.unprocessedServers.addAll(o.unprocessedServers);
            this.noRandomize = o.noRandomize;
            this.noResolveHostnames = o.noResolveHostnames;
            this.reportNoResponders = o.reportNoResponders;
            this.connectionName = o.connectionName;
            this.verbose = o.verbose;
            this.pedantic = o.pedantic;
            this.sslContext = o.sslContext;
            this.maxReconnect = o.maxReconnect;
            this.reconnectWait = o.reconnectWait;
            this.reconnectJitter = o.reconnectJitter;
            this.reconnectJitterTls = o.reconnectJitterTls;
            this.connectionTimeout = o.connectionTimeout;
            this.pingInterval = o.pingInterval;
            this.requestCleanupInterval = o.requestCleanupInterval;
            this.maxPingsOut = o.maxPingsOut;
            this.reconnectBufferSize = o.reconnectBufferSize;
            this.username = o.username;
            this.password = o.password;
            this.token = o.token;
            this.useOldRequestStyle = o.useOldRequestStyle;
            this.maxControlLine = o.maxControlLine;
            this.bufferSize = o.bufferSize;
            this.noEcho = o.noEcho;
            this.noHeaders = o.noHeaders;
            this.noNoResponders = o.noNoResponders;
            this.inboxPrefix = o.inboxPrefix;
            this.traceConnection = o.traceConnection;
            this.maxMessagesInOutgoingQueue = o.maxMessagesInOutgoingQueue;
            this.discardMessagesWhenOutgoingQueueFull = o.discardMessagesWhenOutgoingQueueFull;
            this.authHandler = o.authHandler;
            this.reconnectDelayHandler = o.reconnectDelayHandler;
            this.errorListener = o.errorListener;
            this.connectionListener = o.connectionListener;
            this.dataPortType = o.dataPortType;
            this.trackAdvancedStats = o.trackAdvancedStats;
            this.executor = o.executor;
            this.httpRequestInterceptors = o.httpRequestInterceptors;
            this.proxy = o.proxy;
            this.ignoreDiscoveredServers = o.ignoreDiscoveredServers;
            this.serverPool = o.serverPool;
        }
    }

    static class DefaultThreadFactory
    implements ThreadFactory {
        String name;
        AtomicInteger threadNo = new AtomicInteger(0);

        public DefaultThreadFactory(String name) {
            this.name = name;
        }

        @Override
        public Thread newThread(Runnable r) {
            String threadName = this.name + ":" + this.threadNo.incrementAndGet();
            Thread t = new Thread(r, threadName);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

