/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.api.DeliverPolicy;
import io.nats.client.api.ReplayPolicy;
import io.nats.client.support.Validator;
import java.time.ZonedDateTime;

public class OrderedConsumerConfiguration {
    public static String DEFAULT_FILTER_SUBJECT = ">";
    private String filterSubject = DEFAULT_FILTER_SUBJECT;
    private DeliverPolicy deliverPolicy;
    private Long startSequence = -1L;
    private ZonedDateTime startTime;
    private ReplayPolicy replayPolicy;
    private Boolean headersOnly;

    public OrderedConsumerConfiguration filterSubject(String filterSubject) {
        this.filterSubject = Validator.emptyOrNullAs(filterSubject, DEFAULT_FILTER_SUBJECT);
        return this;
    }

    public OrderedConsumerConfiguration deliverPolicy(DeliverPolicy deliverPolicy) {
        this.deliverPolicy = deliverPolicy;
        return this;
    }

    public OrderedConsumerConfiguration startSequence(long startSequence) {
        this.startSequence = startSequence < 1L ? -1L : startSequence;
        return this;
    }

    public OrderedConsumerConfiguration startTime(ZonedDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public OrderedConsumerConfiguration replayPolicy(ReplayPolicy replayPolicy) {
        this.replayPolicy = replayPolicy;
        return this;
    }

    public OrderedConsumerConfiguration headersOnly(Boolean headersOnly) {
        this.headersOnly = headersOnly != null && headersOnly != false ? Boolean.valueOf(true) : null;
        return this;
    }

    public String getFilterSubject() {
        return this.filterSubject;
    }

    public DeliverPolicy getDeliverPolicy() {
        return this.deliverPolicy;
    }

    public Long getStartSequence() {
        return this.startSequence;
    }

    public ZonedDateTime getStartTime() {
        return this.startTime;
    }

    public ReplayPolicy getReplayPolicy() {
        return this.replayPolicy;
    }

    public Boolean getHeadersOnly() {
        return this.headersOnly;
    }
}

