/*
 * Decompiled with CFR 0.152.
 */
package io.nats.service;

import io.nats.client.Connection;
import io.nats.client.Dispatcher;
import io.nats.client.Message;
import io.nats.client.Subscription;
import io.nats.client.support.DateTimeUtils;
import io.nats.service.EndpointStats;
import io.nats.service.ServiceEndpoint;
import io.nats.service.ServiceMessage;
import io.nats.service.ServiceMessageHandler;
import java.time.ZonedDateTime;
import java.util.concurrent.atomic.AtomicLong;

class EndpointContext {
    private static final String QGROUP = "q";
    private final Connection conn;
    private final ServiceEndpoint se;
    private final ServiceMessageHandler handler;
    private final boolean recordStats;
    private final String qGroup;
    private final boolean internalDispatcher;
    private final Dispatcher dispatcher;
    private Subscription sub;
    private ZonedDateTime started;
    private String lastError;
    private final AtomicLong numRequests;
    private final AtomicLong numErrors;
    private final AtomicLong processingTime;

    EndpointContext(Connection conn, Dispatcher internalDispatcher, boolean recordStats, ServiceEndpoint se) {
        this.conn = conn;
        this.se = se;
        this.handler = se.getHandler();
        this.recordStats = recordStats;
        String string = this.qGroup = recordStats ? QGROUP : null;
        if (se.getDispatcher() == null) {
            this.dispatcher = internalDispatcher;
            this.internalDispatcher = true;
        } else {
            this.dispatcher = se.getDispatcher();
            this.internalDispatcher = false;
        }
        this.numRequests = new AtomicLong();
        this.numErrors = new AtomicLong();
        this.processingTime = new AtomicLong();
        this.started = DateTimeUtils.gmtNow();
    }

    void start() {
        this.sub = this.qGroup == null ? this.dispatcher.subscribe(this.se.getSubject(), this::onMessage) : this.dispatcher.subscribe(this.se.getSubject(), this.qGroup, this::onMessage);
        this.started = DateTimeUtils.gmtNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message msg) throws InterruptedException {
        long start = System.nanoTime();
        ServiceMessage smsg = new ServiceMessage(msg);
        try {
            if (this.recordStats) {
                this.numRequests.incrementAndGet();
            }
            this.handler.onMessage(smsg);
        }
        catch (Throwable t) {
            if (this.recordStats) {
                this.numErrors.incrementAndGet();
                this.lastError = t.toString();
            }
            try {
                smsg.respondStandardError(this.conn, this.lastError, 500);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        finally {
            if (this.recordStats) {
                this.processingTime.addAndGet(System.nanoTime() - start);
            }
        }
    }

    EndpointStats getEndpointStats() {
        return new EndpointStats(this.se.getEndpoint().getName(), this.se.getSubject(), this.numRequests.get(), this.numErrors.get(), this.processingTime.get(), this.lastError, this.se.getStatsDataSupplier() == null ? null : this.se.getStatsDataSupplier().get(), this.started);
    }

    void reset() {
        this.numRequests.set(0L);
        this.numErrors.set(0L);
        this.processingTime.set(0L);
        this.lastError = null;
        this.started = DateTimeUtils.gmtNow();
    }

    boolean isNotInternalDispatcher() {
        return !this.internalDispatcher;
    }

    Subscription getSub() {
        return this.sub;
    }
}

