/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.support;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public abstract class BuilderBase {
    protected final Charset defaultCharset;
    protected int allocationSize;
    public static final int ALLOCATION_BOUNDARY = 32;
    public static final int DEFAULT_ASCII_ALLOCATION = 32;
    public static final int DEFAULT_OTHER_ALLOCATION = 64;
    public static final byte[] NULL = "null".getBytes(StandardCharsets.US_ASCII);

    protected BuilderBase(Charset defaultCharset) {
        this.defaultCharset = defaultCharset;
        this.allocationSize = this._defaultCharsetAllocationSize();
    }

    protected BuilderBase(Charset defaultCharset, int allocationSize) {
        this.defaultCharset = defaultCharset;
        this._setAllocationSize(allocationSize);
    }

    protected void _setAllocationSize(int allocationSizeSuggestion) {
        int dcas = this._defaultCharsetAllocationSize();
        this.allocationSize = allocationSizeSuggestion <= dcas ? dcas : BuilderBase.bufferAllocSize(allocationSizeSuggestion, 32);
    }

    public abstract int length();

    public abstract int capacity();

    public abstract boolean equals(byte[] var1);

    public abstract byte[] toByteArray();

    public abstract byte[] internalArray();

    public abstract int appendUnchecked(byte var1);

    public abstract int appendUnchecked(byte[] var1);

    public abstract int appendUnchecked(byte[] var1, int var2, int var3);

    public int getAllocationSize() {
        return this.allocationSize;
    }

    private int _defaultCharsetAllocationSize() {
        return this.defaultCharset == StandardCharsets.US_ASCII ? 32 : 64;
    }

    public static int bufferAllocSize(int atLeast, int blockSize) {
        return atLeast < blockSize ? blockSize : (atLeast + blockSize) / blockSize * blockSize;
    }
}

