/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.JetStreamApiException;
import io.nats.client.Message;
import io.nats.client.api.ApiResponse;
import io.nats.client.support.ApiConstants;
import io.nats.client.support.JsonUtils;
import java.nio.charset.StandardCharsets;
import java.util.List;

class ListRequestEngine
extends ApiResponse<ListRequestEngine> {
    private static final String OFFSET_JSON_START = "{\"offset\":";
    protected int total = Integer.MAX_VALUE;
    protected int limit = 0;
    protected int lastOffset = 0;

    ListRequestEngine() {
    }

    ListRequestEngine(Message msg) throws JetStreamApiException {
        super(msg);
        if (this.hasError()) {
            throw new JetStreamApiException(this);
        }
        this.total = JsonUtils.readInt(this.json, ApiConstants.TOTAL_RE, -1);
        this.limit = JsonUtils.readInt(this.json, ApiConstants.LIMIT_RE, 0);
        this.lastOffset = JsonUtils.readInt(this.json, ApiConstants.OFFSET_RE, 0);
    }

    boolean hasMore() {
        return this.total > this.nextOffset();
    }

    private byte[] noFilterJson() {
        return (OFFSET_JSON_START + this.nextOffset() + "}").getBytes(StandardCharsets.US_ASCII);
    }

    byte[] internalNextJson() {
        return this.hasMore() ? this.noFilterJson() : null;
    }

    byte[] internalNextJson(String fieldName, String filter) {
        if (this.hasMore()) {
            if (filter == null) {
                return this.noFilterJson();
            }
            return (OFFSET_JSON_START + this.nextOffset() + ",\"" + fieldName + "\":\"" + filter + "\"}").getBytes(StandardCharsets.US_ASCII);
        }
        return null;
    }

    int nextOffset() {
        return this.lastOffset + this.limit;
    }

    List<String> getObjectList(String objectName) {
        return JsonUtils.getObjectList(objectName, this.json);
    }

    List<String> getStringList(String objectName) {
        return JsonUtils.getStringList(objectName, this.json);
    }
}

