/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.support.ApiConstants;
import io.nats.client.support.JsonUtils;

public class AccountLimits {
    private final long maxMemory;
    private final long maxStorage;
    private final long maxStreams;
    private final long maxConsumers;
    private final long maxAckPending;
    private final long memoryMaxStreamBytes;
    private final long storageMaxStreamBytes;
    private final boolean maxBytesRequired;

    AccountLimits(String json) {
        this.maxMemory = JsonUtils.readLong(json, ApiConstants.MAX_MEMORY_RE, 0L);
        this.maxStorage = JsonUtils.readLong(json, ApiConstants.MAX_STORAGE_RE, 0L);
        this.maxStreams = JsonUtils.readLong(json, ApiConstants.MAX_STREAMS_RE, 0L);
        this.maxConsumers = JsonUtils.readLong(json, ApiConstants.MAX_CONSUMERS_RE, 0L);
        this.maxAckPending = JsonUtils.readLong(json, ApiConstants.MAX_ACK_PENDING_RE, 0L);
        this.memoryMaxStreamBytes = JsonUtils.readLong(json, ApiConstants.MEMORY_MAX_STREAM_BYTES_RE, 0L);
        this.storageMaxStreamBytes = JsonUtils.readLong(json, ApiConstants.STORAGE_MAX_STREAM_BYTES_RE, 0L);
        this.maxBytesRequired = JsonUtils.readBoolean(json, ApiConstants.MAX_BYTES_REQUIRED_RE);
    }

    public long getMaxMemory() {
        return this.maxMemory;
    }

    public long getMaxStorage() {
        return this.maxStorage;
    }

    public long getMaxStreams() {
        return this.maxStreams;
    }

    public long getMaxConsumers() {
        return this.maxConsumers;
    }

    public long getMaxAckPending() {
        return this.maxAckPending;
    }

    public long getMemoryMaxStreamBytes() {
        return this.memoryMaxStreamBytes;
    }

    public long getStorageMaxStreamBytes() {
        return this.storageMaxStreamBytes;
    }

    public boolean isMaxBytesRequired() {
        return this.maxBytesRequired;
    }

    public String toString() {
        return "AccountLimits{maxMemory=" + this.maxMemory + ", maxStorage=" + this.maxStorage + ", maxStreams=" + this.maxStreams + ", maxConsumers=" + this.maxConsumers + ", maxAckPending=" + this.maxAckPending + ", memoryMaxStreamBytes=" + this.memoryMaxStreamBytes + ", storageMaxStreamBytes=" + this.storageMaxStreamBytes + ", maxBytesRequired=" + this.maxBytesRequired + '}';
    }
}

