/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.JetStreamOptions;
import io.nats.client.api.External;
import io.nats.client.support.ApiConstants;
import io.nats.client.support.JsonSerializable;
import io.nats.client.support.JsonUtils;
import java.time.ZonedDateTime;

abstract class SourceBase
implements JsonSerializable {
    private final String name;
    private final long startSeq;
    private final ZonedDateTime startTime;
    private final String filterSubject;
    private final External external;
    private final String objectName;

    SourceBase(String objectName, String json) {
        this.name = JsonUtils.readString(json, ApiConstants.NAME_RE);
        this.startSeq = JsonUtils.readLong(json, ApiConstants.OPT_START_SEQ_RE, 0L);
        this.startTime = JsonUtils.readDate(json, ApiConstants.OPT_START_TIME_RE);
        this.filterSubject = JsonUtils.readString(json, ApiConstants.FILTER_SUBJECT_RE);
        this.external = External.optionalInstance(json);
        this.objectName = JsonUtils.normalize(objectName);
    }

    SourceBase(String objectName, SourceBaseBuilder b) {
        this.name = b.name;
        this.startSeq = b.startSeq;
        this.startTime = b.startTime;
        this.filterSubject = b.filterSubject;
        this.external = b.external;
        this.objectName = JsonUtils.normalize(objectName);
    }

    @Override
    public String toJson() {
        StringBuilder sb = JsonUtils.beginJson();
        JsonUtils.addField(sb, "name", this.name);
        if (this.startSeq > 0L) {
            JsonUtils.addField(sb, "opt_start_seq", this.startSeq);
        }
        JsonUtils.addField(sb, "opt_start_time", this.startTime);
        JsonUtils.addField(sb, "filter_subject", this.filterSubject);
        JsonUtils.addField(sb, "external", this.external);
        return JsonUtils.endJson(sb).toString();
    }

    public String getSourceName() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public long getStartSeq() {
        return this.startSeq;
    }

    public ZonedDateTime getStartTime() {
        return this.startTime;
    }

    public String getFilterSubject() {
        return this.filterSubject;
    }

    public External getExternal() {
        return this.external;
    }

    public String toString() {
        return this.objectName + "{name='" + this.name + '\'' + ", startSeq=" + this.startSeq + ", startTime=" + this.startTime + ", filterSubject='" + this.filterSubject + '\'' + ", " + JsonUtils.objectString("external", this.external) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceBase that = (SourceBase)o;
        if (this.startSeq != that.startSeq) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.startTime != null ? !this.startTime.equals(that.startTime) : that.startTime != null) {
            return false;
        }
        if (this.filterSubject != null ? !this.filterSubject.equals(that.filterSubject) : that.filterSubject != null) {
            return false;
        }
        if (this.external != null ? !this.external.equals(that.external) : that.external != null) {
            return false;
        }
        return this.objectName.equals(that.objectName);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (int)(this.startSeq ^ this.startSeq >>> 32);
        result = 31 * result + (this.startTime != null ? this.startTime.hashCode() : 0);
        result = 31 * result + (this.filterSubject != null ? this.filterSubject.hashCode() : 0);
        result = 31 * result + (this.external != null ? this.external.hashCode() : 0);
        result = 31 * result + this.objectName.hashCode();
        return result;
    }

    public static abstract class SourceBaseBuilder<T> {
        String name;
        long startSeq;
        ZonedDateTime startTime;
        String filterSubject;
        External external;

        abstract T getThis();

        public SourceBaseBuilder() {
        }

        public SourceBaseBuilder(SourceBase base) {
            this.name = base.name;
            this.startSeq = base.startSeq;
            this.startTime = base.startTime;
            this.filterSubject = base.filterSubject;
            this.external = base.external;
        }

        public T sourceName(String name) {
            this.name = name;
            return this.getThis();
        }

        public T name(String name) {
            this.name = name;
            return this.getThis();
        }

        public T startSeq(long startSeq) {
            this.startSeq = startSeq;
            return this.getThis();
        }

        public T startTime(ZonedDateTime startTime) {
            this.startTime = startTime;
            return this.getThis();
        }

        public T filterSubject(String filterSubject) {
            this.filterSubject = filterSubject;
            return this.getThis();
        }

        public T external(External external) {
            this.external = external;
            return this.getThis();
        }

        public T domain(String domain) {
            String prefix = JetStreamOptions.convertDomainToPrefix(domain);
            this.external = prefix == null ? null : External.builder().api(prefix).build();
            return this.getThis();
        }
    }
}

