/*
 * Decompiled with CFR 0.152.
 */
package io.nats.service;

import io.nats.client.Connection;
import io.nats.client.Message;
import io.nats.client.NUID;
import io.nats.client.Subscription;
import io.nats.service.InfoResponse;
import io.nats.service.PingResponse;
import io.nats.service.SchemaResponse;
import io.nats.service.ServiceUtil;
import io.nats.service.StatsData;
import io.nats.service.StatsResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;

public class Discovery {
    private final Connection conn;
    private final long maxTimeMillis;
    private final int maxResults;

    public Discovery(Connection conn) {
        this(conn, -1L, -1);
    }

    public Discovery(Connection conn, long maxTimeMillis, int maxResults) {
        this.conn = conn;
        this.maxTimeMillis = maxTimeMillis < 1L ? 5000L : maxTimeMillis;
        this.maxResults = maxResults < 1 ? 10 : maxResults;
    }

    public List<PingResponse> ping() {
        return this.ping(null);
    }

    public List<PingResponse> ping(String serviceName) {
        ArrayList<PingResponse> list = new ArrayList<PingResponse>();
        this.discoverMany("PING", serviceName, json -> list.add(new PingResponse((String)json)));
        return list;
    }

    public PingResponse ping(String serviceName, String serviceId) {
        String json = this.discoverOne("PING", serviceName, serviceId);
        return json == null ? null : new PingResponse(json);
    }

    public List<InfoResponse> info() {
        return this.info(null);
    }

    public List<InfoResponse> info(String serviceName) {
        ArrayList<InfoResponse> list = new ArrayList<InfoResponse>();
        this.discoverMany("INFO", serviceName, json -> list.add(new InfoResponse((String)json)));
        return list;
    }

    public InfoResponse info(String serviceName, String serviceId) {
        String json = this.discoverOne("INFO", serviceName, serviceId);
        return json == null ? null : new InfoResponse(json);
    }

    public List<SchemaResponse> schema() {
        return this.schema(null);
    }

    public List<SchemaResponse> schema(String serviceName) {
        ArrayList<SchemaResponse> list = new ArrayList<SchemaResponse>();
        this.discoverMany("SCHEMA", serviceName, json -> list.add(new SchemaResponse((String)json)));
        return list;
    }

    public SchemaResponse schema(String serviceName, String serviceId) {
        String json = this.discoverOne("SCHEMA", serviceName, serviceId);
        return json == null ? null : new SchemaResponse(json);
    }

    public List<StatsResponse> stats() {
        return this.stats(null, (Function<String, StatsData>)null);
    }

    public List<StatsResponse> stats(Function<String, StatsData> statsDataDecoder) {
        return this.stats(null, statsDataDecoder);
    }

    public List<StatsResponse> stats(String serviceName) {
        return this.stats(serviceName, (Function<String, StatsData>)null);
    }

    public List<StatsResponse> stats(String serviceName, Function<String, StatsData> statsDataDecoder) {
        ArrayList<StatsResponse> list = new ArrayList<StatsResponse>();
        this.discoverMany("STATS", serviceName, json -> list.add(new StatsResponse((String)json, statsDataDecoder)));
        return list;
    }

    public StatsResponse stats(String serviceName, String serviceId) {
        return this.stats(serviceName, serviceId, null);
    }

    public StatsResponse stats(String serviceName, String serviceId, Function<String, StatsData> statsDataDecoder) {
        String json = this.discoverOne("STATS", serviceName, serviceId);
        return json == null ? null : new StatsResponse(json, statsDataDecoder);
    }

    private String discoverOne(String action, String serviceName, String serviceId) {
        String subject = ServiceUtil.toDiscoverySubject(action, serviceName, serviceId);
        try {
            Message m = this.conn.request(subject, null, Duration.ofMillis(this.maxTimeMillis));
            if (m != null) {
                return new String(m.getData());
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discoverMany(String action, String serviceName, Consumer<String> stringConsumer) {
        Subscription sub = null;
        try {
            StringBuilder sb = new StringBuilder(NUID.nextGlobal()).append('-').append(action);
            if (serviceName != null) {
                sb.append('-').append(serviceName);
            }
            String replyTo = sb.toString();
            sub = this.conn.subscribe(replyTo);
            String subject = ServiceUtil.toDiscoverySubject(action, serviceName, null);
            this.conn.publish(subject, replyTo, null);
            long start = System.currentTimeMillis();
            long timeLeft = this.maxTimeMillis;
            for (int resultsLeft = this.maxResults; resultsLeft > 0 && timeLeft > 0L; --resultsLeft) {
                Message msg = sub.nextMessage(timeLeft);
                if (msg == null) {
                    return;
                }
                stringConsumer.accept(new String(msg.getData()));
                timeLeft = this.maxTimeMillis - (System.currentTimeMillis() - start);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            try {
                if (sub != null) {
                    sub.unsubscribe();
                }
            }
            catch (Exception exception) {}
        }
    }
}

