/*
 * Decompiled with CFR 0.152.
 */
package io.nats.service;

import io.nats.client.support.ApiConstants;
import io.nats.client.support.JsonSerializable;
import io.nats.client.support.JsonUtils;

public class InfoResponse
implements JsonSerializable {
    public static final String TYPE = "io.nats.micro.v1.info_response";
    private final String serviceId;
    private final String name;
    private final String version;
    private final String description;
    private final String subject;

    public InfoResponse(String serviceId, String name, String version, String description, String subject) {
        this.serviceId = serviceId;
        this.name = name;
        this.version = version;
        this.description = description;
        this.subject = subject;
    }

    public InfoResponse(String json) {
        this.name = JsonUtils.readString(json, ApiConstants.NAME_RE);
        this.serviceId = JsonUtils.readString(json, ApiConstants.ID_RE);
        this.description = JsonUtils.readString(json, ApiConstants.DESCRIPTION_RE);
        this.version = JsonUtils.readString(json, ApiConstants.VERSION_RE);
        this.subject = JsonUtils.readString(json, ApiConstants.SUBJECT_RE);
    }

    @Override
    public String toJson() {
        StringBuilder sb = JsonUtils.beginJson();
        JsonUtils.addField(sb, "name", this.name);
        JsonUtils.addField(sb, "type", TYPE);
        JsonUtils.addField(sb, "id", this.serviceId);
        JsonUtils.addField(sb, "description", this.description);
        JsonUtils.addField(sb, "version", this.version);
        JsonUtils.addField(sb, "subject", this.subject);
        return JsonUtils.endJson(sb).toString();
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return TYPE;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public String getDescription() {
        return this.description;
    }

    public String getVersion() {
        return this.version;
    }

    public String getSubject() {
        return this.subject;
    }

    public String toString() {
        return this.toJson();
    }
}

