/*
 * Decompiled with CFR 0.152.
 */
package io.nats.service;

import io.nats.client.support.ApiConstants;
import io.nats.client.support.JsonSerializable;
import io.nats.client.support.JsonUtils;

public class PingResponse
implements JsonSerializable {
    public static final String TYPE = "io.nats.micro.v1.ping_response";
    private final String serviceId;
    private final String name;
    private final String version;

    public PingResponse(String serviceId, String name, String version) {
        this.serviceId = serviceId;
        this.name = name;
        this.version = version;
    }

    public PingResponse(String json) {
        this.name = JsonUtils.readString(json, ApiConstants.NAME_RE);
        this.serviceId = JsonUtils.readString(json, ApiConstants.ID_RE);
        this.version = JsonUtils.readString(json, ApiConstants.VERSION_RE);
    }

    @Override
    public String toJson() {
        StringBuilder sb = JsonUtils.beginJson();
        JsonUtils.addField(sb, "name", this.name);
        JsonUtils.addField(sb, "type", TYPE);
        JsonUtils.addField(sb, "id", this.serviceId);
        JsonUtils.addField(sb, "version", this.version);
        return JsonUtils.endJson(sb).toString();
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return TYPE;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public String getVersion() {
        return this.version;
    }

    public String toString() {
        return this.toJson();
    }
}

