/*
 * Decompiled with CFR 0.152.
 */
package io.nats.service;

import io.nats.client.support.ApiConstants;
import io.nats.client.support.JsonSerializable;
import io.nats.client.support.JsonUtils;

public class Schema
implements JsonSerializable {
    private final String request;
    private final String response;

    public static Schema optionalInstance(String fullJson) {
        String objJson = JsonUtils.getJsonObject("schema", fullJson, null);
        return objJson == null ? null : new Schema(objJson);
    }

    public Schema(String request, String response) {
        this.request = request;
        this.response = response;
    }

    protected Schema(String json) {
        this.request = JsonUtils.readString(json, ApiConstants.REQUEST_RE);
        this.response = JsonUtils.readString(json, ApiConstants.RESPONSE_RE);
    }

    @Override
    public String toJson() {
        return JsonUtils.endJson(this.appendSuperFields(JsonUtils.beginJson())).toString();
    }

    protected StringBuilder appendSuperFields(StringBuilder sb) {
        JsonUtils.addField(sb, "request", this.request);
        JsonUtils.addField(sb, "response", this.response);
        return sb;
    }

    public String getRequest() {
        return this.request;
    }

    public String getResponse() {
        return this.response;
    }

    public String toString() {
        return this.toJson();
    }
}

