/*
 * Decompiled with CFR 0.152.
 */
package io.nats.service;

import io.nats.client.support.ApiConstants;
import io.nats.client.support.JsonSerializable;
import io.nats.client.support.JsonUtils;
import io.nats.client.support.Validator;
import io.nats.service.Schema;

public class SchemaResponse
implements JsonSerializable {
    public static final String TYPE = "io.nats.micro.v1.schema_response";
    private final String serviceId;
    private final String name;
    private final String version;
    private final Schema schema;

    public SchemaResponse(String serviceId, String name, String version, String schemaRequest, String schemaResponse) {
        this.serviceId = serviceId;
        this.name = name;
        this.version = version;
        this.schema = Validator.nullOrEmpty(schemaRequest) && Validator.nullOrEmpty(schemaResponse) ? null : new Schema(schemaRequest, schemaResponse);
    }

    public SchemaResponse(String json) {
        this.name = JsonUtils.readString(json, ApiConstants.NAME_RE);
        this.serviceId = JsonUtils.readString(json, ApiConstants.ID_RE);
        this.version = JsonUtils.readString(json, ApiConstants.VERSION_RE);
        this.schema = Schema.optionalInstance(json);
    }

    @Override
    public String toJson() {
        StringBuilder sb = JsonUtils.beginJson();
        JsonUtils.addField(sb, "name", this.name);
        JsonUtils.addField(sb, "type", TYPE);
        JsonUtils.addField(sb, "id", this.serviceId);
        JsonUtils.addField(sb, "version", this.version);
        JsonUtils.addField(sb, "schema", this.schema);
        return JsonUtils.endJson(sb).toString();
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return TYPE;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public String getVersion() {
        return this.version;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public String toString() {
        return this.toJson();
    }
}

