/*
 * Decompiled with CFR 0.152.
 */
package io.nats.service;

import io.nats.client.Connection;
import io.nats.client.Dispatcher;
import io.nats.client.NUID;
import io.nats.client.support.JsonSerializable;
import io.nats.service.InfoResponse;
import io.nats.service.PingResponse;
import io.nats.service.SchemaResponse;
import io.nats.service.ServiceBuilder;
import io.nats.service.StatsData;
import io.nats.service.StatsResponse;
import io.nats.service.context.Context;
import io.nats.service.context.DiscoveryContext;
import io.nats.service.context.ServiceContext;
import io.nats.service.context.StatsContext;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;

public class Service {
    private final Connection conn;
    private final String id = new NUID().next();
    private final Function<String, StatsData> statsDataDecoder;
    private final Duration drainTimeout;
    private final InfoResponse infoResponse;
    private final SchemaResponse schemaResponse;
    private final List<Context> discoveryContexts;
    private final Context serviceContext;
    private final Object stopLock;
    private CompletableFuture<Boolean> doneFuture;

    Service(ServiceBuilder builder) {
        this.conn = builder.conn;
        this.statsDataDecoder = builder.statsDataDecoder;
        this.drainTimeout = builder.drainTimeout;
        this.infoResponse = new InfoResponse(this.id, builder.name, builder.version, builder.description, builder.subject);
        this.schemaResponse = new SchemaResponse(this.id, builder.name, builder.version, builder.schemaRequest, builder.schemaResponse);
        boolean internalDiscovery = builder.dUserDiscovery == null;
        boolean internalService = builder.dUserService == null;
        Dispatcher dDiscovery = internalDiscovery ? this.conn.createDispatcher() : builder.dUserDiscovery;
        Dispatcher dService = internalService ? this.conn.createDispatcher() : builder.dUserService;
        StatsResponse statsResponse = new StatsResponse(this.id, builder.name, builder.version);
        this.serviceContext = new ServiceContext(this.conn, this.infoResponse.getSubject(), dService, internalService, statsResponse, builder.serviceMessageHandler);
        this.discoveryContexts = new ArrayList<Context>();
        this.addDiscoveryContexts("PING", new PingResponse(this.id, builder.name, builder.version), dDiscovery, internalDiscovery);
        this.addDiscoveryContexts("INFO", this.infoResponse, dDiscovery, internalDiscovery);
        this.addDiscoveryContexts("SCHEMA", this.schemaResponse, dDiscovery, internalDiscovery);
        this.addStatsContexts(dDiscovery, internalDiscovery, statsResponse, builder.statsDataSupplier);
        this.stopLock = new Object();
    }

    public CompletableFuture<Boolean> startService() {
        this.doneFuture = new CompletableFuture();
        this.serviceContext.start();
        for (Context ctx : this.discoveryContexts) {
            ctx.start();
        }
        return this.doneFuture;
    }

    public String toString() {
        return "Service" + this.infoResponse.toJson();
    }

    public void stop() {
        this.stop(true, null);
    }

    public void stop(Throwable t) {
        this.stop(true, t);
    }

    public void stop(boolean drain) {
        this.stop(drain, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(boolean drain, Throwable t) {
        Object object = this.stopLock;
        synchronized (object) {
            if (!this.doneFuture.isDone()) {
                ArrayList<Dispatcher> internals = new ArrayList<Dispatcher>();
                if (drain) {
                    ArrayList<CompletableFuture<Boolean>> futures = new ArrayList<CompletableFuture<Boolean>>();
                    this.drain(this.serviceContext, internals, futures);
                    for (Context c : this.discoveryContexts) {
                        this.drain(c, internals, futures);
                    }
                    long drainTimeoutMillis = this.drainTimeout.toMillis();
                    for (CompletableFuture completableFuture : futures) {
                        try {
                            completableFuture.get(drainTimeoutMillis, TimeUnit.MILLISECONDS);
                        }
                        catch (Exception exception) {}
                    }
                }
                for (Dispatcher d : internals) {
                    this.conn.closeDispatcher(d);
                }
                if (t == null) {
                    this.doneFuture.complete(true);
                } else {
                    this.doneFuture.completeExceptionally(t);
                }
            }
        }
    }

    private void drain(Context c, List<Dispatcher> internals, List<CompletableFuture<Boolean>> futures) {
        if (c.isInternalDispatcher()) {
            internals.add(c.getDispatcher());
            try {
                futures.add(c.getDispatcher().drain(this.drainTimeout));
            }
            catch (Exception exception) {}
        } else {
            try {
                futures.add(c.getSub().drain(this.drainTimeout));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void reset() {
        this.serviceContext.getStats().reset();
    }

    public String getId() {
        return this.infoResponse.getServiceId();
    }

    public InfoResponse getInfo() {
        return this.infoResponse;
    }

    public SchemaResponse getSchemaResponse() {
        return this.schemaResponse;
    }

    public StatsResponse getStats() {
        return this.serviceContext.getStats().copy(this.statsDataDecoder);
    }

    private void addDiscoveryContexts(String action, JsonSerializable js, Dispatcher dispatcher, boolean internalDispatcher) {
        this.discoveryContexts.add(new DiscoveryContext(this.conn, action, null, null, js, dispatcher, internalDispatcher));
        this.discoveryContexts.add(new DiscoveryContext(this.conn, action, this.infoResponse.getName(), null, js, dispatcher, internalDispatcher));
        this.discoveryContexts.add(new DiscoveryContext(this.conn, action, this.infoResponse.getName(), this.id, js, dispatcher, internalDispatcher));
    }

    private void addStatsContexts(Dispatcher dispatcher, boolean internalDispatcher, StatsResponse statsResponse, Supplier<StatsData> sds) {
        this.discoveryContexts.add(new StatsContext(this.conn, null, null, dispatcher, internalDispatcher, statsResponse, sds));
        this.discoveryContexts.add(new StatsContext(this.conn, this.infoResponse.getName(), null, dispatcher, internalDispatcher, statsResponse, sds));
        this.discoveryContexts.add(new StatsContext(this.conn, this.infoResponse.getName(), this.id, dispatcher, internalDispatcher, statsResponse, sds));
    }
}

